/*
 * Decompiled with CFR 0.152.
 */
package datahike.java;

import clojure.java.api.Clojure;
import clojure.lang.APersistentMap;
import clojure.lang.APersistentVector;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentVector;
import datahike.java.Datahike;
import datahike.java.IEntity;
import datahike.java.Util;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class DatahikeTest {
    private Object conn;
    private Object schema = Clojure.read((String)" [{:db/ident :name\n                 :db/valueType :db.type/string\n                 :db/unique :db.unique/identity\n                 :db/index true\n                 :db/cardinality :db.cardinality/one}\n                {:db/ident :age\n                 :db/valueType :db.type/long\n                 :db/cardinality :db.cardinality/one}]");
    private APersistentMap config = Util.map(Util.kwd(":store"), Util.map(Util.kwd(":backend"), Util.kwd(":mem")), Util.kwd(":name"), "test-empty-db-java", Util.kwd(":initial-tx"), this.schema);
    private Date firstDate;
    private String query;

    @Before
    public void setUp() throws Exception {
        Datahike.deleteDatabase(this.config);
    }

    @After
    public void tearDown() throws Exception {
        Datahike.deleteDatabase(this.config);
    }

    private void transactOnce() {
        Datahike.createDatabase(this.config);
        this.conn = Datahike.connect(this.config);
        this.query = "[:find ?n ?a :where [?e :name ?n] [?e :age ?a]]";
        Datahike.transact(this.conn, (Iterable)Util.vec(Util.map(Util.kwd(":name"), "Alice", Util.kwd(":age"), 25L), Util.map(Util.kwd(":name"), "Bob", Util.kwd(":age"), 30L)));
    }

    @Test
    public void databaseExists() {
        Datahike.createDatabase(this.config);
        Assert.assertTrue((boolean)Datahike.databaseExists(this.config));
        APersistentMap aPersistentMap = (APersistentMap)Util.ednFromString("{:store {:backend :mem :id \"it-does-not-exist\"}}");
        Assert.assertFalse((boolean)Datahike.databaseExists(aPersistentMap));
    }

    @Test
    public void queryWithDBAndInput() {
        this.transactOnce();
        this.query = "[:find ?n ?a :in $ [?n] :where [?e :name ?n] [?e :age ?a]]";
        Set set = (Set)Datahike.q(this.query, Datahike.deref(this.conn), Clojure.read((String)"[\"Alice\"]"));
        Object[] objectArray = set.stream().map(aPersistentVector -> aPersistentVector.get(0)).toArray();
        Assert.assertTrue((boolean)objectArray[0].equals("Alice"));
    }

    @Test
    public void queryWithJavaArrayInput() {
        this.transactOnce();
        this.query = "[:find ?n ?a :in $ [?n] :where [?e :name ?n] [?e :age ?a]]";
        Set set = (Set)Datahike.q(this.query, Datahike.deref(this.conn), new String[]{"Alice"});
        Object[] objectArray = set.stream().map(aPersistentVector -> aPersistentVector.get(0)).toArray();
        Assert.assertTrue((boolean)objectArray[0].equals("Alice"));
    }

    @Test
    public void queryWithLocalInputDB() {
        Object object = Clojure.read((String)"[[1 :name 'Ivan'] [1 :age  19] [1 :aka  \"dragon_killer_94\"] [1 :aka  '-=autobot=-']]");
        Set set = (Set)Datahike.q("[:find  ?n ?a :where [?e :aka \"dragon_killer_94\"] [?e :name ?n] [?e :age  ?a]]", object);
        Assert.assertTrue((set.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void queryWithDB() {
        Datahike.createDatabase(this.config);
        this.conn = Datahike.connect(this.config);
        Datahike.transact(this.conn, (Iterable)Util.vec(Util.map(Util.kwd(":db/ident"), Util.kwd(":name"), Util.kwd(":db/valueType"), Util.kwd(":db.type/string"), Util.kwd(":db/cardinality"), Util.kwd(":db.cardinality/one"))));
        Datahike.transact(this.conn, (Iterable)Util.vec(Util.map(Util.kwd(":name"), "Alice")));
        Object object = Datahike.deref(this.conn);
        Set set = (Set)Datahike.q("[:find ?e :where [?e :name]]", object);
        Assert.assertTrue((set.size() == 1 ? 1 : 0) != 0);
        set = (Set)Datahike.q("[:find ?v :where [_ :name ?v]]", object);
        Assert.assertEquals((Object)PersistentHashSet.create(Arrays.asList(PersistentVector.create((Object[])new Object[]{"Alice"}))), (Object)set);
    }

    @Test
    public void history() {
        this.transactOnce();
        Set set = (Set)Datahike.q(this.query, Datahike.history(Datahike.deref(this.conn)));
        Object[] objectArray = set.stream().map(aPersistentVector -> aPersistentVector.get(0)).toArray();
        Assert.assertEquals((Object[])new String[]{"Alice", "Bob"}, (Object[])objectArray);
    }

    @Test
    public void asOfAndSince() {
        this.transactOnce();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.firstDate = new Date();
        Datahike.transact(this.conn, (Iterable)Util.vec(Util.map(Util.kwd(":db/id"), Util.vec(Util.kwd(":name"), "Alice"), Util.kwd(":age"), 30L)));
        Set set = (Set)Datahike.q(this.query, Datahike.asOf(Datahike.deref(this.conn), this.firstDate));
        Assert.assertEquals((long)2L, (long)set.size());
        set = (Set)Datahike.q(this.query, Datahike.since(Datahike.deref(this.conn), this.firstDate));
        Assert.assertEquals((long)0L, (long)set.size());
    }

    @Test
    public void pullAndPullMany() {
        this.transactOnce();
        Datahike.transact(this.conn, (Iterable)Util.vec(Util.map(Util.kwd(":db/id"), 10, Util.kwd(":name"), "Joe", Util.kwd(":age"), 50L)));
        APersistentMap aPersistentMap = Datahike.pull(Datahike.deref(this.conn), "[*]", 10L);
        Assert.assertEquals((Object)"Joe", aPersistentMap.get(Util.kwd(":name")));
        Datahike.transact(this.conn, (Iterable)Util.vec(Util.map(Util.kwd(":db/id"), 20, Util.kwd(":name"), "Jane", Util.kwd(":age"), 25L)));
        List list = Datahike.pullMany(Datahike.deref(this.conn), "[*]", (Iterable)Util.vec(10, 20));
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void release() {
        Datahike.createDatabase(this.config);
        this.conn = Datahike.connect(this.config);
        Datahike.release(this.conn);
    }

    @Test
    public void seekDatoms() {
        Datahike.createDatabase(this.config);
        this.conn = Datahike.connect(this.config);
        Datahike.transact(this.conn, (Iterable)((APersistentVector)Clojure.read((String)"[{:db/id 10 :name \"Petr\" :age 44} {:db/id 20 :name \"Ivan\" :age 25} {:db/id 30 :name \"Sergey\" :age 11}]")));
        List list = Datahike.seekdatoms(Datahike.deref(this.conn), Util.kwd(":eavt"), 10);
        list.stream().map(aPersistentVector -> {
            Assert.assertTrue(((Integer)aPersistentVector.get(0) >= 10 ? 1 : 0) != 0);
            return null;
        });
        list = Datahike.seekdatoms(Datahike.deref(this.conn), Util.kwd(":eavt"), 10, Util.kwd(":name"));
        list.stream().map(aPersistentVector -> {
            int n = (Integer)aPersistentVector.get(0);
            Assert.assertTrue((n == 10 && aPersistentVector.get(1).equals(":name") || n > 10 ? 1 : 0) != 0);
            return null;
        });
        list = Datahike.seekdatoms(Datahike.deref(this.conn), Util.kwd(":eavt"), 30, Util.kwd(":name"), "Sergey");
        list.stream().map(aPersistentVector -> {
            int n = (Integer)aPersistentVector.get(0);
            Assert.assertTrue((n == 30 && aPersistentVector.get(1).equals(":name") && aPersistentVector.get(2).equals("Sergey") || n > 30 ? 1 : 0) != 0);
            return null;
        });
    }

    @Test
    public void tempId() {
        Long l = Datahike.tempId(Util.kwd(":db.part/user"));
        Assert.assertTrue((l < 0L ? 1 : 0) != 0);
        l = Datahike.tempId(Util.kwd(":db.part/user"), -10000L);
        Assert.assertEquals((long)-10000L, (long)l);
    }

    @Test
    public void entity() {
        this.transactOnce();
        Datahike.transact(this.conn, (Iterable)Util.vec(Util.map(Util.kwd(":db/id"), 10, Util.kwd(":name"), "Joe", Util.kwd(":age"), 50L)));
        IEntity iEntity = Datahike.entity(Datahike.deref(this.conn), 10L);
        Object object = iEntity.valAt(Util.kwd(":name"));
        Assert.assertEquals((Object)"Joe", (Object)object);
    }

    @Test
    public void entityDb() {
        this.transactOnce();
        Datahike.transact(this.conn, (Iterable)Util.vec(Util.map(Util.kwd(":db/id"), 10, Util.kwd(":name"), "Joe", Util.kwd(":age"), 50L)));
        IEntity iEntity = Datahike.entity(Datahike.deref(this.conn), 10L);
        Object object = Datahike.entityDb(iEntity);
        Assert.assertNotNull((Object)object);
    }

    @Test
    public void filterAndIsFiltered() {
        Datahike.createDatabase(this.config);
        this.conn = Datahike.connect(this.config);
        Assert.assertFalse((boolean)Datahike.isFiltered(Datahike.deref(this.conn)));
        Datahike.transact(this.conn, (Iterable)((APersistentVector)Clojure.read((String)"[{:db/id 10 :name \"Petr\" :age 44} {:db/id 20 :name \"Ivan\" :age 25} {:db/id 30 :name \"Sergey\" :age 11}]")));
        Object object = Datahike.filter(Datahike.deref(this.conn), Clojure.read((String)"(fn [_ datom] (not= :age (:a datom)))"));
        Assert.assertTrue((boolean)Datahike.isFiltered(object));
    }

    @Test
    public void dbWith() {
        Datahike.createDatabase(this.config);
        this.conn = Datahike.connect(this.config);
        APersistentVector aPersistentVector = (APersistentVector)Clojure.read((String)"[{:db/id 10 :name \"Petr\" :age 44} {:db/id 20 :name \"Ivan\" :age 25} {:db/id 30 :name \"Sergey\" :age 11}]");
        Object object = Datahike.dbWith(Datahike.deref(this.conn), aPersistentVector);
        this.query = "[:find ?a :in $ :where [?e :age ?a]]";
        Set set = (Set)Datahike.q(this.query, object);
        Assert.assertTrue((set.size() == 3 ? 1 : 0) != 0);
    }

    public static boolean run() {
        Result result = JUnitCore.runClasses((Class[])new Class[]{DatahikeTest.class});
        System.out.println("\n");
        List list = result.getFailures();
        for (Failure failure : list) {
            System.out.println("Junit Failure: " + failure.toString());
        }
        System.out.println("Java Bindings test failure count: " + list.size());
        return result.wasSuccessful();
    }
}

