/*
 * Decompiled with CFR 0.152.
 */
package datahike.java;

import clojure.java.api.Clojure;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentVector;
import datahike.java.Datahike;
import datahike.java.IEntity;
import datahike.java.Util;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class DatahikeTest {
    private String uri = "datahike:mem://test-empty-db-java";
    private Object conn;
    private Object schema = Clojure.read((String)" [{:db/ident :name\n                 :db/valueType :db.type/string\n                 :db/unique :db.unique/identity\n                 :db/index true\n                 :db/cardinality :db.cardinality/one}\n                {:db/ident :age\n                 :db/valueType :db.type/long\n                 :db/cardinality :db.cardinality/one}]");
    private Date firstDate;
    private String query;

    @Before
    public void setUp() throws Exception {
        Datahike.deleteDatabase(this.uri);
    }

    @After
    public void tearDown() throws Exception {
        Datahike.deleteDatabase(this.uri);
    }

    private void transactOnce() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        this.conn = Datahike.connect(this.uri);
        this.query = "[:find ?n ?a :where [?e :name ?n] [?e :age ?a]]";
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":name"), "Alice", Util.k(":age"), 25L), Util.map(Util.k(":name"), "Bob", Util.k(":age"), 30L)));
    }

    @Test
    public void db() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        this.conn = Datahike.connect(this.uri);
        Assert.assertEquals((Object)Datahike.db(this.conn), (Object)Datahike.dConn(this.conn));
    }

    @Test
    public void databaseExists() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        Assert.assertTrue((boolean)Datahike.databaseExists(this.uri));
        Assert.assertFalse((boolean)Datahike.databaseExists("datahike:mem://not-exists"));
    }

    @Test
    public void queryWithDBAndInput() {
        this.transactOnce();
        this.query = "[:find ?n ?a :in $ [?n] :where [?e :name ?n] [?e :age ?a]]";
        Set<PersistentVector> res = Datahike.q(this.query, Datahike.dConn(this.conn), Clojure.read((String)"[\"Alice\"]"));
        Object[] names = res.stream().map(vec -> vec.get(0)).toArray();
        Assert.assertTrue((boolean)names[0].equals("Alice"));
    }

    @Test
    public void queryWithJavaArrayInput() {
        this.transactOnce();
        this.query = "[:find ?n ?a :in $ [?n] :where [?e :name ?n] [?e :age ?a]]";
        Set<PersistentVector> res = Datahike.q(this.query, Datahike.dConn(this.conn), new String[]{"Alice"});
        Object[] names = res.stream().map(vec -> vec.get(0)).toArray();
        Assert.assertTrue((boolean)names[0].equals("Alice"));
    }

    @Test
    public void queryWithLocalInputDB() {
        Object input = Clojure.read((String)"[[1 :name 'Ivan'] [1 :age  19] [1 :aka  \"dragon_killer_94\"] [1 :aka  '-=autobot=-']]");
        Set<PersistentVector> res = Datahike.q("[:find  ?n ?a :where [?e :aka \"dragon_killer_94\"] [?e :name ?n] [?e :age  ?a]]", input);
        Assert.assertTrue((res.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void queryWithDB() {
        Datahike.createDatabase(this.uri);
        this.conn = Datahike.connect(this.uri);
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":db/ident"), Util.k(":name"), Util.k(":db/valueType"), Util.k(":db.type/string"), Util.k(":db/cardinality"), Util.k(":db.cardinality/one"))));
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":name"), "Alice")));
        Object dConn = Util.deref.invoke(this.conn);
        Set<PersistentVector> res = Datahike.q("[:find ?e :where [?e :name]]", dConn);
        Assert.assertTrue((res.size() == 1 ? 1 : 0) != 0);
        res = Datahike.q("[:find ?v :where [_ :name ?v]]", dConn);
        Assert.assertEquals((Object)PersistentHashSet.create(Arrays.asList(PersistentVector.create((Object[])new Object[]{"Alice"}))), res);
    }

    @Test
    public void history() {
        this.transactOnce();
        Set<PersistentVector> res = Datahike.q(this.query, Datahike.history(Datahike.dConn(this.conn)));
        Object[] names = res.stream().map(pv -> pv.get(0)).toArray();
        Assert.assertEquals((Object[])new String[]{"Alice", "Bob"}, (Object[])names);
    }

    @Test
    public void asOfAndSince() {
        this.transactOnce();
        this.firstDate = new Date();
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":db/id"), Util.vec(Util.k(":name"), "Alice"), Util.k(":age"), 30L)));
        Set<PersistentVector> res = Datahike.q(this.query, Datahike.asOf(Datahike.dConn(this.conn), this.firstDate));
        Assert.assertEquals((long)2L, (long)res.size());
        res = Datahike.q(this.query, Datahike.since(Datahike.dConn(this.conn), this.firstDate));
        Assert.assertEquals((long)0L, (long)res.size());
    }

    @Test
    public void pullAndPullMany() {
        this.transactOnce();
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":db/id"), 10, Util.k(":name"), "Joe", Util.k(":age"), 50L)));
        Map res = Datahike.pull(Datahike.dConn(this.conn), "[*]", 10);
        Assert.assertEquals((Object)"Joe", res.get(Util.k(":name")));
        res = Datahike.pull(Datahike.dConn(this.conn), "[*]", Util.vec(Util.k(":name"), "Alice"));
        Assert.assertEquals((Object)"Alice", res.get(Util.k(":name")));
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":db/id"), 20, Util.k(":name"), "Jane", Util.k(":age"), 25L)));
        List list = Datahike.pullMany(Datahike.dConn(this.conn), "[*]", Util.vec(10, 20));
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void release() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        this.conn = Datahike.connect(this.uri);
        Datahike.release(this.conn);
    }

    @Test
    public void seekDatoms() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        this.conn = Datahike.connect(this.uri);
        Datahike.transact(this.conn, (PersistentVector)Clojure.read((String)"[{:db/id 10 :name \"Petr\" :age 44} {:db/id 20 :name \"Ivan\" :age 25} {:db/id 30 :name \"Sergey\" :age 11}]"));
        List res = Datahike.seekdatoms(Datahike.dConn(this.conn), Util.k(":eavt"), 10);
        res.stream().map(vec -> {
            Assert.assertTrue(((Integer)vec.get(0) >= 10 ? 1 : 0) != 0);
            return null;
        });
        res = Datahike.seekdatoms(Datahike.dConn(this.conn), Util.k(":eavt"), 10, Util.k(":name"));
        res.stream().map(vec -> {
            int entityId = (Integer)vec.get(0);
            Assert.assertTrue((entityId == 10 && vec.get(1).equals(":name") || entityId > 10 ? 1 : 0) != 0);
            return null;
        });
        res = Datahike.seekdatoms(Datahike.dConn(this.conn), Util.k(":eavt"), 30, Util.k(":name"), "Sergey");
        res.stream().map(vec -> {
            int entityId = (Integer)vec.get(0);
            Assert.assertTrue((entityId == 30 && vec.get(1).equals(":name") && vec.get(2).equals("Sergey") || entityId > 30 ? 1 : 0) != 0);
            return null;
        });
    }

    @Test
    public void tempId() {
        Long id = Datahike.tempId(Util.k(":db.part/user"));
        Assert.assertTrue((id < 0L ? 1 : 0) != 0);
        id = Datahike.tempId(Util.k(":db.part/user"), -10000L);
        Assert.assertEquals((long)-10000L, (long)id);
    }

    @Test
    public void entity() {
        this.transactOnce();
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":db/id"), 10, Util.k(":name"), "Joe", Util.k(":age"), 50L)));
        IEntity entity = Datahike.entity(Datahike.dConn(this.conn), 10);
        Object res = entity.valAt(Util.k(":name"));
        Assert.assertEquals((Object)"Joe", (Object)res);
    }

    @Test
    public void entityDb() {
        this.transactOnce();
        Datahike.transact(this.conn, Util.vec(Util.map(Util.k(":db/id"), 10, Util.k(":name"), "Joe", Util.k(":age"), 50L)));
        IEntity entity = Datahike.entity(Datahike.dConn(this.conn), 10);
        Object db = Datahike.entityDb(entity);
        Assert.assertNotNull((Object)db);
    }

    @Test
    public void filterAndIsFiltered() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        this.conn = Datahike.connect(this.uri);
        Assert.assertFalse((boolean)Datahike.isFiltered(Datahike.dConn(this.conn)));
        Datahike.transact(this.conn, (PersistentVector)Clojure.read((String)"[{:db/id 10 :name \"Petr\" :age 44} {:db/id 20 :name \"Ivan\" :age 25} {:db/id 30 :name \"Sergey\" :age 11}]"));
        Object filteredDB = Datahike.filter(Datahike.dConn(this.conn), Clojure.read((String)"(fn [_ datom] (not= :age (:a datom)))"));
        Assert.assertTrue((boolean)Datahike.isFiltered(filteredDB));
    }

    @Test
    public void dbWith() {
        Datahike.createDatabase(this.uri, Util.k(":initial-tx"), this.schema);
        this.conn = Datahike.connect(this.uri);
        PersistentVector txData = (PersistentVector)Clojure.read((String)"[{:db/id 10 :name \"Petr\" :age 44} {:db/id 20 :name \"Ivan\" :age 25} {:db/id 30 :name \"Sergey\" :age 11}]");
        Object dbAfter = Datahike.dbWith(Datahike.dConn(this.conn), txData);
        this.query = "[:find ?a :in $ :where [?e :age ?a]]";
        Set<PersistentVector> res = Datahike.q(this.query, dbAfter);
        Assert.assertTrue((res.size() == 3 ? 1 : 0) != 0);
    }

    public static boolean run() {
        Result result = JUnitCore.runClasses((Class[])new Class[]{DatahikeTest.class});
        System.out.println("\n");
        List failures = result.getFailures();
        for (Failure failure : failures) {
            System.out.println("Junit Failure: " + failure.toString());
        }
        System.out.println("Java Bindings test failure count: " + failures.size());
        return result.wasSuccessful();
    }
}

