/*
 * Decompiled with CFR 0.152.
 */
package datahike.java;

import clojure.java.api.Clojure;
import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import datahike.java.IEntity;
import datahike.java.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Datahike {
    private static final IFn deleteDatabaseFn;
    private static final IFn createDatabaseFn;
    private static final IFn connectFn;
    private static final IFn transactFn;
    private static final IFn dbFn;
    private static final IFn qFn;
    private static final IFn historyFn;
    private static final IFn asOfFn;
    private static final IFn sinceFn;
    private static final IFn pullFn;
    private static final IFn releaseFn;
    private static final IFn pullManyFn;
    private static final IFn seekDatomsFn;
    private static final IFn tempIdFn;
    private static final IFn entityFn;
    private static final IFn entityDbFn;
    private static final IFn isFilteredFn;
    private static final IFn filterFn;
    private static final IFn withFn;
    private static final IFn dbWithFn;
    private static final IFn databaseExistsFn;

    private Datahike() {
    }

    public static Object dConn(Object conn) {
        return Util.deref.invoke(conn);
    }

    public static boolean databaseExists(Object uri_or_map) {
        return (Boolean)databaseExistsFn.invoke(uri_or_map);
    }

    public static void deleteDatabase(String uri) {
        deleteDatabaseFn.invoke((Object)uri);
    }

    public static void createDatabase(String uri) {
        createDatabaseFn.invoke((Object)uri);
    }

    public static void createDatabase(String uri, Object ... args) {
        ArrayList<Object> argsCopy = new ArrayList<Object>(Arrays.asList(args));
        argsCopy.add(0, uri);
        createDatabaseFn.applyTo(RT.seq(argsCopy));
    }

    public static Object connect(String uri) {
        return connectFn.invoke((Object)uri);
    }

    public static Object db(Object conn) {
        return dbFn.invoke(conn);
    }

    public static Set<PersistentVector> q(String query, Object ... inputs) {
        ArrayList<Object> argsCopy = new ArrayList<Object>(Arrays.asList(inputs));
        argsCopy.add(0, Clojure.read((String)query));
        return (Set)qFn.applyTo(RT.seq(argsCopy));
    }

    public static Object transact(Object conn, PersistentVector txData) {
        return transactFn.invoke(conn, (Object)txData);
    }

    public static Object history(Object dConn) {
        return historyFn.invoke(dConn);
    }

    public static Object asOf(Object dConn, Date date) {
        return asOfFn.invoke(dConn, (Object)date);
    }

    public static Object since(Object dConn, Date date) {
        return sinceFn.invoke(dConn, (Object)date);
    }

    public static Map pull(Object dConn, String selector, int eid) {
        return (Map)pullFn.invoke(dConn, Clojure.read((String)selector), (Object)eid);
    }

    public static Map pull(Object dConn, String selector, PersistentVector eid) {
        return (Map)pullFn.invoke(dConn, Clojure.read((String)selector), (Object)eid);
    }

    public static List pullMany(Object dConn, String selector, PersistentVector eids) {
        return (List)pullManyFn.invoke(dConn, Clojure.read((String)selector), (Object)eids);
    }

    public static void release(Object conn) {
        releaseFn.invoke(conn);
    }

    public static List seekdatoms(Object dConn, Keyword index, Object c1) {
        return (List)seekDatomsFn.invoke(dConn, (Object)index, c1);
    }

    public static List seekdatoms(Object dConn, Keyword index, Object c1, Object c2) {
        return (List)seekDatomsFn.invoke(dConn, (Object)index, c1, c2);
    }

    public static List seekdatoms(Object dConn, Keyword index, Object c1, Object c2, Object c3) {
        return (List)seekDatomsFn.invoke(dConn, (Object)index, c1, c2, c3);
    }

    public static List seekdatoms(Object dConn, Keyword index, Object c1, Object c2, Object c3, Object c4) {
        return (List)seekDatomsFn.invoke(dConn, (Object)index, c1, c2, c3, c4);
    }

    public static Long tempId(Keyword k) {
        return (Long)tempIdFn.invoke((Object)k);
    }

    public static Long tempId(Keyword k, Long i) {
        return (Long)tempIdFn.invoke((Object)k, (Object)i);
    }

    public static IEntity entity(Object dConn, int eid) {
        return (IEntity)entityFn.invoke(dConn, (Object)eid);
    }

    public static Object entityDb(IEntity entity) {
        return entityDbFn.invoke((Object)entity);
    }

    public static boolean isFiltered(Object dConn) {
        return (Boolean)isFilteredFn.invoke(dConn);
    }

    public static Object filter(Object dConn, Object pred) {
        return filterFn.invoke(dConn, pred);
    }

    public static Object dbWith(Object dConn, Object txData) {
        return dbWithFn.invoke(dConn, txData);
    }

    static {
        IFn require = Clojure.var((Object)"clojure.core", (Object)"require");
        require.invoke(Clojure.read((String)"datahike.api"));
        deleteDatabaseFn = Clojure.var((Object)"datahike.api", (Object)"delete-database");
        createDatabaseFn = Clojure.var((Object)"datahike.api", (Object)"create-database");
        connectFn = Clojure.var((Object)"datahike.api", (Object)"connect");
        transactFn = Clojure.var((Object)"datahike.api", (Object)"transact");
        dbFn = Clojure.var((Object)"datahike.api", (Object)"db");
        qFn = Clojure.var((Object)"datahike.api", (Object)"q");
        historyFn = Clojure.var((Object)"datahike.api", (Object)"history");
        asOfFn = Clojure.var((Object)"datahike.api", (Object)"as-of");
        sinceFn = Clojure.var((Object)"datahike.api", (Object)"since");
        pullFn = Clojure.var((Object)"datahike.api", (Object)"pull");
        releaseFn = Clojure.var((Object)"datahike.api", (Object)"release");
        pullManyFn = Clojure.var((Object)"datahike.api", (Object)"pull-many");
        seekDatomsFn = Clojure.var((Object)"datahike.api", (Object)"seek-datoms");
        tempIdFn = Clojure.var((Object)"datahike.api", (Object)"tempid");
        entityFn = Clojure.var((Object)"datahike.api", (Object)"entity");
        entityDbFn = Clojure.var((Object)"datahike.api", (Object)"entity-db");
        isFilteredFn = Clojure.var((Object)"datahike.api", (Object)"is-filtered");
        filterFn = Clojure.var((Object)"datahike.api", (Object)"filter");
        withFn = Clojure.var((Object)"datahike.api", (Object)"with");
        dbWithFn = Clojure.var((Object)"datahike.api", (Object)"db-with");
        databaseExistsFn = Clojure.var((Object)"datahike.api", (Object)"database-exists?");
    }
}

