(ns wizard-bot.core
  (:require [discord-bot.core :as discord]
            [wizard-bot.clients.cards :as cards]
            [wizard-bot.config :refer [get-config] :as config]))

(defn handle-message-create
  [{:keys [content]}]
  (when-let [card-data (->> content
                            (re-seq #"\(\((.*?)\)\)")
                            (keep #(when % (cards/get-card-data (second %))))
                            seq)]
    (doseq [{:keys [name image_uris mana_cost] :as card} card-data]
      (discord/send-channel-message (get-config [:channel-id]) {:content (str name " | " mana_cost)
                                                                :embed {:image {:url (:large image_uris)}}}))))

(comment
  (if (= "mystical tutor" (second (re-find #"\(\((.*?)\)\)" content)))
        (discord/send-channel-message (get-config [:channel-id]) {:content img-urls} #_(seq img-urls))
        (discord/send-channel-message (get-config [:channel-id]) {:content img-urls})))

(defn random-mtga-quip
  []
  (first (shuffle ["Hope you studied your tomes!"
                   "Watch out for lightning bolts!"
                   "Dare another Wizard of some stature challenge them?"
                   "Don't forget to don your cloak!"])))

(defn handle-presence-update
  [data]
  (let [user-id (get-in data [:user :id])
        {{:keys [username bot]} :user} (discord/get-user-by-id user-id)
        {:keys [name] :as game} (:game data)
        current-presence (some (fn [p] (when (= user-id (get-in p [:user :id]))
                                         p)) (discord/get-presences))]
    (when-let [msg (case (get-in data [:game :name])
                     "MTGArena" (str username " started playing MTGA. " (random-mtga-quip))
                     "Destiny 2" (str username " started playing Destiny 2.")
                     nil)]
      (when (and (discord/started-new-game? (:game current-presence) game) (not bot))
        (discord/send-channel-message (get-config [:channel-id]) msg)))))

(comment
  (discord/get-presences)
  (discord/init {:on-message-create handle-message-create
                 :on-presence-update handle-presence-update}))
