(ns wizard-bot.config
  (:require [clojure.core.memoize :as memo]))

(defn load-config*
  []
  (clojure.edn/read-string (slurp "./config.edn")))

(def load-config (memo/ttl load-config* :ttl/threshold (* 10 1000)))

(defn get-config
  [path]
  (get-in (load-config) path))
