(ns wizard-bot.clients.cards
  (:require [clj-http.client :as http]))
; handle 404 errors
(defn get-card-data
  [card-name]
  (try (-> (http/get (str "https://api.scryfall.com/cards/named?fuzzy=" card-name) {:as :json})
           :body)
       (catch Exception e (println "Error searching for card " card-name " :" (ex-data e)))))

(defn get-card-image-url
  [card-name]
  (try (-> (get-card-data card-name)
           (get-in [:image_uris :large]))
       (catch Exception e (println "Error searching for card " card-name " :" (ex-data e)))))

(comment
  (def ayara (get-card-data "ayara first of locthwain"))
  (def krasis (get-card-data "nighthowler"))
 (get-in krasis [:image_uris :large])
  (keys krasis)
  (:rulings_uri krasis))
