/*
 * Decompiled with CFR 0.152.
 */
package io.raven.vertx.jmxmp;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JmxMpServer
implements Verticle {
    private static final Logger log = LogManager.getLogger(JmxMpServer.class);
    private Vertx vertx;
    private JsonObject config;
    private int port;
    private JMXConnectorServer cs;

    public Vertx getVertx() {
        return this.vertx;
    }

    public void init(Vertx vertx, Context context) {
        try {
            this.vertx = vertx;
            this.config = context.config();
            this.port = this.config.getInteger("jmxmp-port");
            log.info("Starting JMXMP server on port: {}", (Object)this.port);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            HashMap env = new HashMap();
            JMXServiceURL url = new JMXServiceURL("jmxmp", null, this.port);
            this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
        }
        catch (Exception e) {
            log.error("Error starting JMXMP server on port: {}", (Object)this.port, (Object)e);
        }
    }

    @Deprecated
    public void start(Future<Void> future) throws Exception {
        this.cs.start();
        log.info("Started JMXMP server on port: {} successfully", (Object)this.port);
        future.complete();
    }

    public void start(Promise<Void> startPromise) throws Exception {
        this.cs.start();
        log.info("Started JMXMP server on port: {} successfully", (Object)this.port);
        startPromise.complete();
    }

    @Deprecated
    public void stop(Future<Void> future) throws Exception {
        log.info("Stopping JMXMP server");
        this.cs.stop();
        log.info("Stopped JMXMP server successfully");
        future.complete();
    }

    public void stop(Promise<Void> stopPromise) throws Exception {
        log.info("Stopping JMXMP server");
        this.cs.stop();
        log.info("Stopped JMXMP server successfully");
        stopPromise.complete();
    }
}

