/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.model;

import io.dropwizard.primer.model.PrimerEndpoint;
import javax.annotation.Nonnegative;
import lombok.NonNull;

public class PrimerSimpleEndpoint
extends PrimerEndpoint {
    private String type;
    @NonNull
    private String host;
    @Nonnegative
    private int port;

    public PrimerSimpleEndpoint(String type, String host, int port) {
        this(type, host, port, "", false);
    }

    private int getDefaultPort() {
        if (this.isSecure()) {
            return 443;
        }
        return 80;
    }

    private PrimerSimpleEndpoint(String type, String host, int port, String rootPathPrefix, boolean secure) {
        super(rootPathPrefix, secure);
        this.type = type;
        this.host = host;
        this.port = port;
    }

    public int getPort() {
        if (this.port == 0) {
            return this.getDefaultPort();
        }
        return this.port;
    }

    public static PrimerSimpleEndpointBuilder builder() {
        return new PrimerSimpleEndpointBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimerSimpleEndpoint)) {
            return false;
        }
        PrimerSimpleEndpoint other = (PrimerSimpleEndpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrimerSimpleEndpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPort();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public PrimerSimpleEndpoint() {
    }

    @Override
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setHost(@NonNull String host) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        return "PrimerSimpleEndpoint(type=" + this.getType() + ", host=" + this.getHost() + ", port=" + this.getPort() + ")";
    }

    public static class PrimerSimpleEndpointBuilder {
        private String type;
        private String host;
        private int port;
        private String rootPathPrefix;
        private boolean secure;

        PrimerSimpleEndpointBuilder() {
        }

        public PrimerSimpleEndpointBuilder type(String type) {
            this.type = type;
            return this;
        }

        public PrimerSimpleEndpointBuilder host(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            this.host = host;
            return this;
        }

        public PrimerSimpleEndpointBuilder port(int port) {
            this.port = port;
            return this;
        }

        public PrimerSimpleEndpoint build() {
            return new PrimerSimpleEndpoint(this.type, this.host, this.port);
        }

        public String toString() {
            return "PrimerSimpleEndpoint.PrimerSimpleEndpointBuilder(type=" + this.type + ", host=" + this.host + ", port=" + this.port + ")";
        }

        public PrimerSimpleEndpointBuilder rootPathPrefix(String rootPathPrefix) {
            this.rootPathPrefix = rootPathPrefix;
            return this;
        }

        public PrimerSimpleEndpointBuilder secure(boolean secure) {
            this.secure = secure;
            return this;
        }
    }
}

