/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.authorizer;

import io.dropwizard.primer.auth.annotation.Authorize;
import io.dropwizard.primer.auth.authorizer.PrimerAnnotationAuthorizer;
import io.dropwizard.primer.exception.PrimerException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimerRoleAuthorizer
implements PrimerAnnotationAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(PrimerRoleAuthorizer.class);

    @Override
    public void authorize(JwtClaims jwtClaims, ContainerRequestContext containerRequestContext, Authorize authorize) throws PrimerException {
        List<String> authorizedRoles = Arrays.asList(authorize.value());
        if (authorizedRoles.contains(jwtClaims.getClaimValueAsString("role"))) {
            return;
        }
        if (jwtClaims.getClaimValue("roles") != null && !Collections.disjoint(authorizedRoles, (List)jwtClaims.getClaimValue("roles"))) {
            return;
        }
        throw PrimerException.builder().status(401).errorCode("PR004").message("Unauthorized").recoverable(true).build();
    }

    PrimerRoleAuthorizer() {
    }

    public static PrimerRoleAuthorizerBuilder builder() {
        return new PrimerRoleAuthorizerBuilder();
    }

    public static class PrimerRoleAuthorizerBuilder {
        PrimerRoleAuthorizerBuilder() {
        }

        public PrimerRoleAuthorizer build() {
            return new PrimerRoleAuthorizer();
        }

        public String toString() {
            return "PrimerRoleAuthorizer.PrimerRoleAuthorizerBuilder()";
        }
    }
}

