/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.InvalidSignatureException;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.MalformedJsonWebTokenException;
import com.github.toastshaman.dropwizard.auth.jwt.exceptions.TokenExpiredException;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import feign.FeignException;
import io.dropwizard.primer.auth.AuthType;
import io.dropwizard.primer.auth.PrimerAuthorizationRegistry;
import io.dropwizard.primer.auth.token.PrimerTokenProvider;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerConfigurationHolder;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthFilter.class);
    protected final AuthType authType;
    protected final PrimerConfigurationHolder configHolder;
    protected final ObjectMapper objectMapper;
    protected final PrimerTokenProvider primerTokenProvider;

    protected AuthFilter(AuthType authType, PrimerConfigurationHolder configHolder, ObjectMapper objectMapper, PrimerTokenProvider primerTokenProvider) {
        this.authType = authType;
        this.configHolder = configHolder;
        this.objectMapper = objectMapper;
        this.primerTokenProvider = primerTokenProvider;
    }

    protected JsonWebToken authorize(ContainerRequestContext requestContext, String token, AuthType authType) {
        return PrimerAuthorizationRegistry.authorize(requestContext.getUriInfo().getPath(), requestContext.getMethod(), token, authType);
    }

    public Optional<String> getToken(ContainerRequestContext requestContext) {
        return this.primerTokenProvider.getToken(requestContext, this.configHolder);
    }

    protected void handleException(Throwable e, ContainerRequestContext requestContext, String token) throws JsonProcessingException {
        if (e.getCause() instanceof TokenExpiredException || e instanceof TokenExpiredException) {
            log.error("Token Expiry Error: {}", (Object)e.getMessage());
            this.abortRequest(requestContext, Response.Status.PRECONDITION_FAILED, PrimerError.builder().errorCode("PR003").message("Expired").build());
        } else if (e.getCause() instanceof MalformedJsonWebTokenException || e instanceof MalformedJsonWebTokenException) {
            log.error("Token Malformed Error: {}", (Object)e.getMessage());
            this.abortRequest(requestContext, Response.Status.UNAUTHORIZED, PrimerError.builder().errorCode("PR004").message("Unauthorized").build());
        } else if (e.getCause() instanceof InvalidSignatureException || e instanceof InvalidSignatureException) {
            log.error("Token Signature Error: {}", (Object)e.getMessage());
            this.abortRequest(requestContext, Response.Status.UNAUTHORIZED, PrimerError.builder().errorCode("PR004").message("Unauthorized").build());
        } else if (e.getCause() instanceof FeignException) {
            log.error("Feign error: {}", (Object)e.getMessage());
            this.handleError(Response.Status.fromStatusCode((int)((FeignException)e.getCause()).status()), "PR000", e.getCause().getMessage(), token, false, requestContext);
        } else if (e instanceof FeignException) {
            log.error("Feign error: {}", (Object)e.getMessage());
            this.handleError(Response.Status.fromStatusCode((int)((FeignException)e).status()), "PR000", e.getMessage(), token, false, requestContext);
        } else if (e.getCause() instanceof PrimerException) {
            PrimerException primerException = (PrimerException)e.getCause();
            log.error("Primer error: {}", (Object)e.getMessage());
            log.debug("Primer error: {} status: {} errorCode: {} message: {} headers: {}", new Object[]{e.getMessage(), primerException.getStatus(), primerException.getErrorCode(), primerException.getMessage(), requestContext.getHeaders()});
            this.handleError(Response.Status.fromStatusCode((int)((PrimerException)e.getCause()).getStatus()), ((PrimerException)e.getCause()).getErrorCode(), e.getCause().getMessage(), token, ((PrimerException)e.getCause()).isRecoverable(), requestContext);
        } else if (e instanceof PrimerException) {
            PrimerException primerException = (PrimerException)e;
            log.error("Primer error: {}", (Object)e.getMessage());
            log.debug("Primer error: {} status: {} errorCode: {} message: {} headers: {}", new Object[]{e.getMessage(), primerException.getStatus(), primerException.getErrorCode(), primerException.getMessage(), requestContext.getHeaders()});
            this.handleError(Response.Status.fromStatusCode((int)((PrimerException)e).getStatus()), ((PrimerException)e).getErrorCode(), e.getMessage(), token, ((PrimerException)e).isRecoverable(), requestContext);
        } else {
            log.error("General error: ", e);
            this.handleError(Response.Status.INTERNAL_SERVER_ERROR, "PR000", "Error", token, false, requestContext);
        }
    }

    protected void handleError(Response.Status status, String errorCode, String message, String token, boolean recoverable, ContainerRequestContext requestContext) throws JsonProcessingException {
        switch (status) {
            case NOT_FOUND: 
            case UNAUTHORIZED: {
                if (!recoverable) {
                    PrimerAuthorizationRegistry.blacklist(token);
                }
                this.abortRequest(requestContext, Response.Status.UNAUTHORIZED, PrimerError.builder().errorCode("PR004").message("Unauthorized").build());
                break;
            }
            case FORBIDDEN: {
                if (!recoverable) {
                    PrimerAuthorizationRegistry.blacklist(token);
                }
                this.abortRequest(requestContext, Response.Status.FORBIDDEN, PrimerError.builder().errorCode("PR002").message("Forbidden").build());
                break;
            }
            default: {
                this.abortRequest(requestContext, status, PrimerError.builder().errorCode(errorCode).message(message).build());
            }
        }
    }

    protected void abortRequest(ContainerRequestContext requestContext, Response.Status status, PrimerError primerError) throws JsonProcessingException {
        requestContext.abortWith(Response.status((int)status.getStatusCode()).entity((Object)this.objectMapper.writeValueAsBytes((Object)primerError)).build());
    }
}

