/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.oor;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.oor.BirHook;
import io.dropwizard.oor.OorHook;
import io.dropwizard.oor.healtcheck.OorHealthCheck;
import io.dropwizard.oor.tasks.BirTask;
import io.dropwizard.oor.tasks.OorTask;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OorBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(OorBundle.class);
    private Set<OorHook> oorHooks = new TreeSet<OorHook>();
    private Set<BirHook> birHooks = new TreeSet<BirHook>();

    public abstract boolean withOor();

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void registerOorHook(OorHook oorHook) {
        this.oorHooks.add(oorHook);
    }

    public void registerBirHook(BirHook birHook) {
        this.birHooks.add(birHook);
    }

    public void run(T configuration, Environment environment) throws Exception {
        environment.healthChecks().register("oor", (HealthCheck)new OorHealthCheck(this.withOor()));
        environment.admin().addTask((Task)new OorTask(this.oorHooks));
        environment.admin().addTask((Task)new BirTask(this.birHooks));
    }
}

