/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.maxmind.geoip2.provider;

import com.google.common.base.Strings;
import io.dropwizard.maxmind.geoip2.core.MaxMindInfo;
import io.dropwizard.maxmind.geoip2.provider.MaxMindContext;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import lombok.Generated;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MaxMindInfoProvider
extends AbstractValueParamProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MaxMindInfoProvider.class);
    public static final String UNKNOWN = "UNKNOWN";

    private static MaxMindInfo createMaxMindInfo(ContainerRequest request) {
        String anonymousIp = request.getHeaderString("X-MAXMIND-REQUEST-ANONYMOUS-IP");
        String anonymousVpn = request.getHeaderString("X-MAXMIND-REQUEST-ANONYMOUS-VPN");
        String tor = request.getHeaderString("X-MAXMIND-REQUEST-TOR-NODE");
        String city = request.getHeaderString("X-MAXMIND-REQUEST-CITY");
        String state = request.getHeaderString("X-MAXMIND-REQUEST-STATE");
        String stateIso = request.getHeaderString("X-MAXMIND-REQUEST-STATE-ISO");
        String postal = request.getHeaderString("X-MAXMIND-REQUEST-POSTAL-CODE");
        String connectionType = request.getHeaderString("X-MAXMIND-REQUEST-CONNECTION-TYPE");
        String userType = request.getHeaderString("X-MAXMIND-REQUEST-USER-TYPE");
        String country = request.getHeaderString("X-MAXMIND-REQUEST-COUNTRY");
        String countryIso = request.getHeaderString("X-MAXMIND-REQUEST-COUNTRY-ISO");
        String isp = request.getHeaderString("X-MAXMIND-REQUEST-ISP");
        String latitude = request.getHeaderString("X-MAXMIND-REQUEST-LATITUDE");
        String longitude = request.getHeaderString("X-MAXMIND-REQUEST-LONGITUDE");
        String accuracy = request.getHeaderString("X-MAXMIND-REQUEST-LOCATION-ACCURACY");
        return MaxMindInfo.builder().anonymousIp(!Strings.isNullOrEmpty((String)anonymousIp) && Boolean.parseBoolean(anonymousIp)).anonymousVpn(!Strings.isNullOrEmpty((String)anonymousVpn) && Boolean.parseBoolean(anonymousVpn)).tor(!Strings.isNullOrEmpty((String)tor) && Boolean.parseBoolean(tor)).city(Strings.isNullOrEmpty((String)city) ? UNKNOWN : city).state(Strings.isNullOrEmpty((String)state) ? UNKNOWN : state).stateIso(Strings.isNullOrEmpty((String)stateIso) ? UNKNOWN : stateIso).country(Strings.isNullOrEmpty((String)country) ? UNKNOWN : country).countryIso(Strings.isNullOrEmpty((String)countryIso) ? UNKNOWN : countryIso).postal(Strings.isNullOrEmpty((String)postal) ? UNKNOWN : postal).connectionType(Strings.isNullOrEmpty((String)connectionType) ? UNKNOWN : connectionType).userType(Strings.isNullOrEmpty((String)userType) ? UNKNOWN : userType).isp(Strings.isNullOrEmpty((String)isp) ? UNKNOWN : isp).latitude(Strings.isNullOrEmpty((String)latitude) ? 0.0 : Double.parseDouble(latitude)).longitude(Strings.isNullOrEmpty((String)longitude) ? 0.0 : Double.parseDouble(longitude)).accuracy(Strings.isNullOrEmpty((String)accuracy) ? 0 : Integer.parseInt(accuracy)).build();
    }

    @Inject
    public MaxMindInfoProvider(Provider<MultivaluedParameterExtractorProvider> mpep) {
        super(mpep, new Parameter.Source[]{Parameter.Source.UNKNOWN});
    }

    protected Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        Class classType = parameter.getRawType();
        if (classType == null || !classType.equals(MaxMindInfo.class)) {
            log.warn("MaxMindContext annotation was not placed on correct object type; Injection might not work correctly!");
            return null;
        }
        return MaxMindInfoProvider::createMaxMindInfo;
    }

    public static class Binder
    extends AbstractBinder {
        protected void configure() {
            this.bind(MaxMindInfoProvider.class).to(ValueParamProvider.class).in(Singleton.class);
            this.bind(MaxMindContextInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<MaxMindContext>>(){}).in(Singleton.class);
        }
    }

    @Singleton
    public static final class MaxMindContextInjectionResolver
    extends ParamInjectionResolver<MaxMindContext> {
        @Inject
        public MaxMindContextInjectionResolver(MaxMindInfoProvider valueParamProvider, Provider<ContainerRequest> request) {
            super((ValueParamProvider)valueParamProvider, MaxMindContext.class, request);
        }
    }
}

