/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.maxmind.geoip2.filter;

import com.google.common.base.Strings;
import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.EnterpriseResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.Subdivision;
import com.maxmind.geoip2.record.Traits;
import io.dropwizard.maxmind.geoip2.config.MaxMindConfig;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import lombok.Generated;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=3000)
public class MaxMindGeoIpRequestFilter
implements ContainerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MaxMindGeoIpRequestFilter.class);
    private final MaxMindConfig config;
    private DatabaseReader databaseReader;

    public MaxMindGeoIpRequestFilter(MaxMindConfig config) {
        this.config = config;
        try {
            this.databaseReader = new DatabaseReader.Builder(new File(config.getDatabaseFilePath())).withCache((NodeCache)new CHMCache()).build();
        }
        catch (IOException e) {
            log.error("Error initializing GeoIP database", (Throwable)e);
        }
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        String clientAddress = (String)containerRequestContext.getHeaders().getFirst((Object)this.config.getRemoteIpHeader());
        if (Strings.isNullOrEmpty((String)clientAddress)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Header: {} | Value: {}", (Object)this.config.getRemoteIpHeader(), (Object)clientAddress);
        }
        String[] addresses = clientAddress.split(",");
        InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();
        if (!inetAddressValidator.isValid(addresses[0])) {
            log.warn("Invalid IP Address: {}", (Object)addresses[0]);
            return;
        }
        String clientIp = addresses[0];
        if (!Strings.isNullOrEmpty((String)clientIp)) {
            InetAddress address;
            try {
                address = InetAddress.getByName(clientIp);
            }
            catch (Exception e) {
                log.warn("Cannot resolve address: {} | Error: {}", (Object)clientIp, (Object)e.getMessage());
                return;
            }
            if (address == null) {
                log.warn("Cannot resolve address: {}", (Object)clientIp);
                return;
            }
            try {
                if (this.config.isEnterprise()) {
                    AnonymousIpResponse anonymousIpResponse;
                    EnterpriseResponse enterpriseResponse = this.databaseReader.enterprise(address);
                    if (enterpriseResponse == null) {
                        return;
                    }
                    this.addInfo(containerRequestContext, enterpriseResponse.getCountry(), enterpriseResponse.getMostSpecificSubdivision(), enterpriseResponse.getCity(), enterpriseResponse.getPostal(), enterpriseResponse.getLocation());
                    if (enterpriseResponse.getTraits() != null) {
                        this.addTraitsInfo(enterpriseResponse.getTraits(), containerRequestContext);
                    }
                    if ((anonymousIpResponse = this.databaseReader.anonymousIp(address)) != null) {
                        this.anonymousInfo(anonymousIpResponse, containerRequestContext);
                    }
                } else {
                    this.addInfo(containerRequestContext, address);
                }
            }
            catch (Exception e) {
                log.warn("GeoIP Error: {}", (Object)e.getMessage());
            }
        }
    }

    private void addInfo(ContainerRequestContext containerRequestContext, InetAddress address) throws IOException, GeoIp2Exception {
        switch (this.config.getType()) {
            case "country": {
                CountryResponse countryResponse = this.databaseReader.country(address);
                if (countryResponse == null || countryResponse.getCountry() == null) break;
                this.addCountryInfo(countryResponse.getCountry(), containerRequestContext);
                break;
            }
            case "city": {
                CityResponse cityResponse = this.databaseReader.city(address);
                if (cityResponse == null) break;
                this.addInfo(containerRequestContext, cityResponse.getCountry(), cityResponse.getMostSpecificSubdivision(), cityResponse.getCity(), cityResponse.getPostal(), cityResponse.getLocation());
                break;
            }
            case "anonymous": {
                AnonymousIpResponse anonymousIpResponse = this.databaseReader.anonymousIp(address);
                if (anonymousIpResponse == null) break;
                this.anonymousInfo(anonymousIpResponse, containerRequestContext);
                break;
            }
            default: {
                containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-ERROR", (Object)"UNKNOWN_TYPE");
            }
        }
    }

    private void addInfo(ContainerRequestContext containerRequestContext, Country country, Subdivision mostSpecificSubdivision, City city, Postal postal, Location location) {
        if (country != null) {
            this.addCountryInfo(country, containerRequestContext);
        }
        if (mostSpecificSubdivision != null) {
            this.addStateInfo(mostSpecificSubdivision, containerRequestContext);
        }
        if (city != null) {
            this.addCityInfo(city, containerRequestContext);
        }
        if (postal != null) {
            this.addPostalInfo(postal, containerRequestContext);
        }
        if (location != null) {
            this.addLocationInfo(location, containerRequestContext);
        }
    }

    private void addCountryInfo(Country country, ContainerRequestContext containerRequestContext) {
        if (!Strings.isNullOrEmpty((String)country.getName())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-COUNTRY", (Object)this.toAscii(country.getName()));
        }
        if (!Strings.isNullOrEmpty((String)country.getIsoCode())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-COUNTRY-ISO", (Object)country.getIsoCode());
        }
    }

    private void addStateInfo(Subdivision subdivision, ContainerRequestContext containerRequestContext) {
        if (!Strings.isNullOrEmpty((String)subdivision.getName())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-STATE", (Object)this.toAscii(subdivision.getName()));
        }
        if (!Strings.isNullOrEmpty((String)subdivision.getIsoCode())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-STATE-ISO", (Object)subdivision.getIsoCode());
        }
    }

    private void addCityInfo(City city, ContainerRequestContext containerRequestContext) {
        if (!Strings.isNullOrEmpty((String)city.getName())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-CITY", (Object)this.toAscii(city.getName()));
        }
    }

    private void addPostalInfo(Postal postal, ContainerRequestContext containerRequestContext) {
        if (!Strings.isNullOrEmpty((String)postal.getCode())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-POSTAL-CODE", (Object)postal.getCode());
        }
    }

    private void addLocationInfo(Location location, ContainerRequestContext containerRequestContext) {
        if (location.getLatitude() != null) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-LATITUDE", (Object)String.valueOf(location.getLatitude()));
        }
        if (location.getLongitude() != null) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-LONGITUDE", (Object)String.valueOf(location.getLongitude()));
        }
        if (location.getAccuracyRadius() != null) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-LOCATION-ACCURACY", (Object)String.valueOf(location.getAccuracyRadius()));
        }
    }

    private void addTraitsInfo(Traits traits, ContainerRequestContext containerRequestContext) {
        if (!Strings.isNullOrEmpty((String)traits.getUserType())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-USER-TYPE", (Object)this.toAscii(traits.getUserType()));
        }
        if (!Strings.isNullOrEmpty((String)traits.getIsp())) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-ISP", (Object)this.toAscii(traits.getIsp()));
        }
        if (traits.getConnectionType() != null) {
            containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-CONNECTION-TYPE", (Object)this.toAscii(traits.getConnectionType().name()));
        }
        containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-LEGAL-PROXY", (Object)String.valueOf(traits.isLegitimateProxy()));
    }

    private void anonymousInfo(AnonymousIpResponse anonymousIpResponse, ContainerRequestContext containerRequestContext) {
        containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-ANONYMOUS-IP", (Object)String.valueOf(anonymousIpResponse.isAnonymous()));
        containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-ANONYMOUS-VPN", (Object)String.valueOf(anonymousIpResponse.isAnonymousVpn()));
        containerRequestContext.getHeaders().putSingle((Object)"X-MAXMIND-REQUEST-TOR-NODE", (Object)String.valueOf(anonymousIpResponse.isTorExitNode()));
    }

    private String toAscii(String input) {
        if (!Strings.isNullOrEmpty((String)input)) {
            return input.replaceAll("[^\\x20-\\x7e]", "");
        }
        return input;
    }
}

