/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jmxmp.managed;

import io.dropwizard.lifecycle.Managed;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMpServer
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(JmxMpServer.class);
    private int port;
    private JMXConnectorServer cs;

    public JmxMpServer(int port) {
        this.port = port;
    }

    public void start() {
        try {
            log.info("Starting JMXMP server on port: {}", (Object)this.port);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            HashMap env = new HashMap();
            JMXServiceURL url = new JMXServiceURL("jmxmp", null, this.port);
            JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
            cs.start();
            log.info("Started JMXMP server on port: {} successfully", (Object)this.port);
        }
        catch (Exception e) {
            log.error("Error starting JMXMP server on port: {}", (Object)this.port, (Object)e);
        }
    }

    public void stop() throws Exception {
        log.info("Stopping JMXMP server");
        this.cs.stop();
        log.info("Stopped JMXMP server successfully");
    }

    public static JmxMpServerBuilder builder() {
        return new JmxMpServerBuilder();
    }

    public static class JmxMpServerBuilder {
        private int port;

        JmxMpServerBuilder() {
        }

        public JmxMpServerBuilder port(int port) {
            this.port = port;
            return this;
        }

        public JmxMpServer build() {
            return new JmxMpServer(this.port);
        }

        public String toString() {
            return "JmxMpServer.JmxMpServerBuilder(port=" + this.port + ")";
        }
    }
}

