/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt;

import io.dropwizard.auth.jwt.PrincipalContainerRequestValueFactory;
import io.dropwizard.auth.jwt.annotation.JwtAuthRequired;
import java.security.Principal;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;

public class JwtUserValueFactoryProvider<T extends Principal>
extends AbstractValueParamProvider {
    private final Class<T> principalClass;

    @Inject
    public JwtUserValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, PrincipalClassProvider<T> principalClassProvider) {
        super(() -> mpep, new Parameter.Source[]{Parameter.Source.UNKNOWN});
        this.principalClass = principalClassProvider.clazz;
    }

    @Nullable
    protected Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        if (!parameter.isAnnotationPresent(JwtAuthRequired.class)) {
            return null;
        }
        if (this.principalClass.equals(parameter.getRawType())) {
            return request -> new PrincipalContainerRequestValueFactory((ContainerRequest)request).provide();
        }
        return null;
    }

    @Singleton
    static class PrincipalClassProvider<T extends Principal> {
        private final Class<T> clazz;

        PrincipalClassProvider(Class<T> clazz) {
            this.clazz = clazz;
        }
    }

    public static class Binder<T extends Principal>
    extends AbstractBinder {
        private final Class<T> principalClass;

        public Binder(Class<T> principalClass) {
            this.principalClass = principalClass;
        }

        protected void configure() {
            this.bind(new PrincipalClassProvider<T>(this.principalClass)).to(PrincipalClassProvider.class);
            ((ClassBinding)this.bind(JwtUserValueFactoryProvider.class).to(ValueParamProvider.class)).in(Singleton.class);
        }
    }
}

