/*
 * Decompiled with CFR 0.152.
 */
package io.raven.db.utils;

import io.raven.db.utils.TransactionHandler;
import java.util.function.Function;
import org.hibernate.SessionFactory;

public interface Transactions {
    public static <T, U> T execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg) {
        return (T)Transactions.execute(sessionFactory, readOnly, function, arg, t -> t);
    }

    public static <T, U, V> V execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg, Function<T, V> handler) {
        return Transactions.execute(sessionFactory, readOnly, function, arg, handler, true);
    }

    public static <T, U, V> V execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg, Function<T, V> handler, boolean completeTransaction) {
        TransactionHandler transactionHandler = new TransactionHandler(sessionFactory, readOnly);
        if (completeTransaction) {
            transactionHandler.beforeStart();
        }
        try {
            T result = function.apply(arg);
            V returnValue = handler.apply(result);
            if (completeTransaction) {
                transactionHandler.afterEnd();
            }
            return returnValue;
        }
        catch (Exception e) {
            if (completeTransaction) {
                transactionHandler.onError(e);
            }
            throw e;
        }
    }
}

