/*
 * Decompiled with CFR 0.152.
 */
package io.raven.db.dao;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.raven.db.annotations.LookupKey;
import io.raven.db.dao.AbstractDao;
import io.raven.db.dao.DaoException;
import io.raven.db.utils.TransactionHandler;
import io.raven.db.utils.Transactions;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.persistence.Id;
import javax.persistence.criteria.CriteriaUpdate;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupDao<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookupDao.class);
    private final Class<T> entityClass;
    private final Field idField;
    private final Field keyField;
    @VisibleForTesting
    private final InternalDao dao;

    public LookupDao(SessionFactory sessionFactory, Class<T> entityClass) {
        this.dao = new InternalDao(sessionFactory);
        this.entityClass = entityClass;
        Field[] lookupFields = FieldUtils.getFieldsWithAnnotation(entityClass, LookupKey.class);
        Field[] idFields = FieldUtils.getFieldsWithAnnotation(entityClass, Id.class);
        Preconditions.checkArgument((lookupFields.length != 0 ? 1 : 0) != 0, (Object)"At least one field needs to be lookup keys");
        Preconditions.checkArgument((lookupFields.length == 1 ? 1 : 0) != 0, (Object)"Only one field can be lookup keys");
        Preconditions.checkArgument((idFields.length != 0 ? 1 : 0) != 0, (Object)"At least one field needs to be a key");
        Preconditions.checkArgument((idFields.length == 1 ? 1 : 0) != 0, (Object)"Only one field can be a key");
        this.keyField = lookupFields[0];
        Preconditions.checkArgument((boolean)ClassUtils.isAssignable(this.keyField.getType(), String.class), (Object)"Lookup Key field must be a string");
        if (!this.keyField.trySetAccessible()) {
            log.error("Error making LookupKey field accessible please use a public method and mark that as LookupKey");
            throw new IllegalArgumentException("Invalid class, DAO cannot be created. LookupKey is not accessible");
        }
        this.idField = idFields[0];
        Preconditions.checkArgument((boolean)ClassUtils.isAssignable(this.idField.getType(), Long.class), (Object)"Key field must be a Long");
        if (!this.keyField.trySetAccessible()) {
            log.error("Error making Key field accessible please use a public method and mark that as Key");
            throw new IllegalArgumentException("Invalid class, DAO cannot be created. Key is not accessible");
        }
    }

    public Class<T> getEntityClass() {
        return this.dao.getEntityClass();
    }

    public Optional<T> get(Long id) throws Exception {
        return this.get(id, (T t) -> t);
    }

    public <U> Optional<U> get(Long id, Function<T, U> handler) throws Exception {
        U result = Transactions.execute(this.dao.sessionFactory, true, this.dao::get, id, handler);
        return Optional.ofNullable(result);
    }

    public List<T> get(List<Long> ids) throws Exception {
        return this.get(ids, (List<T> e) -> e);
    }

    public <U> List<U> get(List<Long> ids, Function<List<T>, List<U>> handler) throws Exception {
        return Transactions.execute(this.dao.sessionFactory, true, this.dao::get, ids, handler);
    }

    public Optional<T> lookup(String key) throws Exception {
        return this.lookup(key, e -> e);
    }

    public <U> Optional<U> lookup(String key, Function<T, U> handler) throws Exception {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.entityClass).add((Criterion)Restrictions.eq((String)this.keyField.getName(), (Object)key));
        U result = Transactions.execute(this.dao.sessionFactory, true, this.dao::selectSingle, criteria, handler);
        return Optional.ofNullable(result);
    }

    public <U> List<U> lookupMulti(String key, Function<List<T>, List<U>> handler) throws Exception {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.entityClass).add((Criterion)Restrictions.eq((String)this.keyField.getName(), (Object)key));
        return Transactions.execute(this.dao.sessionFactory, true, this.dao::select, criteria, handler);
    }

    public List<T> lookupMulti(String key) throws Exception {
        return this.lookupMulti(key, t -> t);
    }

    public List<T> get(DetachedCriteria criteria) throws Exception {
        return Transactions.execute(this.dao.sessionFactory, true, this.dao::select, criteria, e -> e);
    }

    public <U> List<U> get(DetachedCriteria criteria, Function<List<T>, List<U>> handler) throws Exception {
        return Transactions.execute(this.dao.sessionFactory, true, this.dao::select, criteria, handler);
    }

    public boolean exists(Long id) throws Exception {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.entityClass).add((Criterion)Restrictions.eq((String)this.idField.getName(), (Object)id)).setProjection((Projection)Projections.property((String)this.idField.getName()));
        Object result = Transactions.execute(this.dao.sessionFactory, true, this.dao::selectSingle, criteria, e -> e);
        return Objects.nonNull(result);
    }

    public boolean exists(String key) throws Exception {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.entityClass).add((Criterion)Restrictions.eq((String)this.keyField.getName(), (Object)key)).setProjection((Projection)Projections.property((String)this.idField.getName()));
        Object result = Transactions.execute(this.dao.sessionFactory, true, this.dao::selectSingle, criteria, e -> e);
        return Objects.nonNull(result);
    }

    public <N extends Number> N max(DetachedCriteria criteria, String propertyName) throws Exception {
        return (N)Transactions.execute(this.dao.sessionFactory, true, this.dao::max, AggregateParams.builder().criteria(criteria).propertyName(propertyName).build());
    }

    public <N extends Number> N min(DetachedCriteria criteria, String propertyName) throws Exception {
        return (N)Transactions.execute(this.dao.sessionFactory, true, this.dao::min, AggregateParams.builder().criteria(criteria).propertyName(propertyName).build());
    }

    public <U> U save(T entity, Function<T, U> handler) throws Exception {
        return Transactions.execute(this.dao.sessionFactory, false, this.dao::save, entity, handler);
    }

    public Optional<T> save(T entity) throws Exception {
        return Optional.ofNullable(this.save(entity, (T t) -> t));
    }

    public <U> List<U> save(List<T> entities, Function<List<T>, List<U>> handler) throws Exception {
        return Transactions.execute(this.dao.sessionFactory, false, this.dao::save, entities, handler);
    }

    public List<T> save(List<T> entities) throws Exception {
        return this.save(entities, (List<T> t) -> t);
    }

    public boolean updateInLock(Long id, Function<Optional<T>, T> updater) {
        return this.updateImpl(id, this.dao::getLockedForWrite, updater, this.dao);
    }

    private boolean updateImpl(Long id, Function<Long, T> getter, Function<Optional<T>, T> updater, InternalDao dao) {
        try {
            return Transactions.execute(dao.sessionFactory, false, getter, id, entity -> {
                if (null == entity) {
                    return false;
                }
                Object newEntity = updater.apply(Optional.of(entity));
                if (null == newEntity) {
                    return false;
                }
                dao.update(newEntity);
                return true;
            });
        }
        catch (Exception e) {
            throw new DaoException("Error updating entity: " + id, e);
        }
    }

    public boolean update(Long id, Function<Optional<T>, T> updater) {
        return this.updateImpl(id, this.dao::get, updater, this.dao);
    }

    public int update(String query, Map<String, Object> params) throws Exception {
        return Transactions.execute(this.dao.sessionFactory, false, this.dao::update, QueryParams.builder().params(params).query(query).nativeQuery(false).build());
    }

    public int updateNative(String query, Map<String, Object> params) throws Exception {
        return Transactions.execute(this.dao.sessionFactory, false, this.dao::update, QueryParams.builder().params(params).query(query).nativeQuery(true).build());
    }

    public LockedContext<T> lockAndGetExecutor(Long id) {
        return new LockedContext<Long>(this.dao.sessionFactory, (Function<Long, Long>)((Function<Long, Object>)this.dao::getLockedForWrite), id);
    }

    public BatchLockedContext<T> lockAndGetExecutor(List<Long> ids) {
        return new BatchLockedContext(this.dao.sessionFactory, this.dao::getLockedForWrite, ids, true);
    }

    public BatchLockedContext<T> lockAndGetExecutor(Supplier<List<Long>> supplier) {
        return this.lockAndGetExecutor(supplier.get());
    }

    public BatchLockedContext<T> saveAndGetExecutor(List<T> entities) {
        return new BatchLockedContext(this.dao.sessionFactory, this.dao::save, entities);
    }

    public LockedContext<T> saveAndGetExecutor(T entity) {
        return new LockedContext<Object>(this.dao.sessionFactory, this.dao::save, entity);
    }

    public <N extends Number> N sum(DetachedCriteria criteria, String propertyName) throws Exception {
        return (N)Transactions.execute(this.dao.sessionFactory, true, this.dao::sum, AggregateParams.builder().criteria(criteria).propertyName(propertyName).build());
    }

    public long count(DetachedCriteria criteria) {
        try {
            criteria.setProjection((Projection)Projections.property((String)this.idField.getName()));
            return Transactions.execute(this.dao.sessionFactory, true, this.dao::count, criteria);
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    public List<T> select(DetachedCriteria detachedCriteria, int limit, int offset) throws Exception {
        return this.select(detachedCriteria, limit, offset, ts -> ts);
    }

    public List<T> select(String query, Map<String, Object> params, boolean nativeQuery) throws Exception {
        QueryParams queryParams = QueryParams.builder().query(query).params(params).nativeQuery(nativeQuery).build();
        return Transactions.execute(this.dao.sessionFactory, true, this.dao::select, queryParams);
    }

    public <U> List<U> select(DetachedCriteria detachedCriteria, int limit, int offset, Function<List<T>, List<U>> handler) throws Exception {
        CriteriaParams params = CriteriaParams.builder().criteria(detachedCriteria).limit(limit).offset(offset).build();
        try {
            return Transactions.execute(this.dao.sessionFactory, true, this.dao::select, params, handler);
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    public <U> List<U> selectPaginated(DetachedCriteria criteria, Function<List<T>, List<U>> handler, int pageSize) {
        try {
            CriteriaParams params = CriteriaParams.builder().criteria(criteria).limit(pageSize).build();
            return Transactions.execute(this.dao.sessionFactory, true, this.dao::selectPaginated, params, handler);
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    public List<T> select(DetachedCriteria detachedCriteria) throws Exception {
        try {
            return Transactions.execute(this.dao.sessionFactory, true, this.dao::select, detachedCriteria, t -> t);
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    public <U> List<U> select(DetachedCriteria detachedCriteria, Function<List<T>, List<U>> handler) throws Exception {
        try {
            return Transactions.execute(this.dao.sessionFactory, true, this.dao::select, detachedCriteria, handler);
        }
        catch (Exception e) {
            throw new DaoException(e);
        }
    }

    public <U> Optional<U> selectSingle(DetachedCriteria detachedCriteria, Function<T, U> handler) throws Exception {
        U result = Transactions.execute(this.dao.sessionFactory, true, this.dao::selectSingle, detachedCriteria, handler);
        return Optional.ofNullable(result);
    }

    protected Field getKeyField() {
        return this.keyField;
    }

    protected Field getIdField() {
        return this.idField;
    }

    private final class InternalDao
    extends AbstractDao<T> {
        private final SessionFactory sessionFactory;

        public InternalDao(SessionFactory sessionFactory) {
            super(sessionFactory);
            this.sessionFactory = sessionFactory;
        }

        T get(Long id) {
            return this.getLocked(id, LockMode.READ);
        }

        T getLocked(Long id, LockMode lockMode) {
            return this.currentSession().get(LookupDao.this.entityClass, (Serializable)id, lockMode);
        }

        List<T> get(List<Long> ids) {
            return this.getLocked(ids, LockMode.READ);
        }

        List<T> getLocked(List<Long> ids, LockMode lockMode) {
            MultiIdentifierLoadAccess multiGet = this.currentSession().byMultipleIds(LookupDao.this.entityClass);
            return multiGet.with(new LockOptions(lockMode)).multiLoad(ids);
        }

        T getLockedForWrite(Long id) {
            return this.getLocked(id, LockMode.UPGRADE_NOWAIT);
        }

        List<T> getLockedForWrite(List<Long> ids) {
            return this.getLocked(ids, LockMode.UPGRADE_NOWAIT);
        }

        T save(T entity) {
            return this.persist(entity);
        }

        List<T> save(List<T> entities) {
            ArrayList saved = new ArrayList();
            for (Object e : entities) {
                saved.add(this.persist(e));
            }
            return saved;
        }

        void update(T entity) {
            this.currentSession().evict(entity);
            this.currentSession().update(entity);
        }

        long update(CriteriaUpdate<T> criteriaUpdate) {
            return this.currentSession().createQuery(criteriaUpdate).executeUpdate();
        }

        List<T> select(DetachedCriteria criteria) {
            return this.list(criteria.getExecutableCriteria(this.currentSession()));
        }

        public List<T> select(QueryParams queryParams) {
            Query tQuery = this.currentSession().createQuery(queryParams.query, LookupDao.this.entityClass);
            if (queryParams.params != null) {
                queryParams.params.forEach((arg_0, arg_1) -> ((Query)tQuery).setParameter(arg_0, arg_1));
            }
            return tQuery.getResultList();
        }

        public List<T> select(CriteriaParams criteriaParams) {
            Criteria exeCriteria = criteriaParams.criteria.getExecutableCriteria(this.currentSession());
            if (criteriaParams.limit != -1) {
                exeCriteria.setMaxResults(criteriaParams.limit);
            }
            if (criteriaParams.offset != -1) {
                exeCriteria.setFirstResult(criteriaParams.offset);
            }
            if (!Strings.isNullOrEmpty((String)criteriaParams.fetchProfile)) {
                this.currentSession().enableFetchProfile(criteriaParams.fetchProfile);
            }
            return this.list(exeCriteria);
        }

        public List<T> selectPaginated(CriteriaParams criteriaParams) {
            ArrayList result = new ArrayList();
            boolean run = true;
            int offset = 0;
            while (run) {
                Criteria exeCriteria = criteriaParams.criteria.getExecutableCriteria(this.currentSession());
                exeCriteria.setMaxResults(criteriaParams.limit);
                exeCriteria.setFirstResult(offset);
                List batchResult = this.list(exeCriteria);
                result.addAll(batchResult);
                offset += criteriaParams.limit;
                run = !batchResult.isEmpty();
            }
            return result;
        }

        public T selectSingle(DetachedCriteria criteria) {
            return this.uniqueResult(criteria.getExecutableCriteria(this.currentSession()));
        }

        long count(DetachedCriteria criteria) {
            return (Long)criteria.getExecutableCriteria(this.currentSession()).setProjection(Projections.rowCount()).uniqueResult();
        }

        <N extends Number> N sum(AggregateParams aggregateParams) {
            return (N)((Number)aggregateParams.criteria.getExecutableCriteria(this.currentSession()).setProjection((Projection)Projections.sum((String)aggregateParams.propertyName)).uniqueResult());
        }

        <N extends Number> N max(AggregateParams aggregateParams) {
            return (N)((Number)aggregateParams.criteria.getExecutableCriteria(this.currentSession()).setProjection((Projection)Projections.max((String)aggregateParams.propertyName)).uniqueResult());
        }

        <N extends Number> N min(AggregateParams aggregateParams) {
            return (N)((Number)aggregateParams.criteria.getExecutableCriteria(this.currentSession()).setProjection((Projection)Projections.min((String)aggregateParams.propertyName)).uniqueResult());
        }

        public int update(QueryParams updateParams) {
            Object tQuery = updateParams.nativeQuery ? this.currentSession().createSQLQuery(updateParams.query) : this.currentSession().createQuery(updateParams.query);
            updateParams.params.forEach((arg_0, arg_1) -> ((Query)tQuery).setParameter(arg_0, arg_1));
            return tQuery.executeUpdate();
        }
    }

    public static class BatchLockedContext<T> {
        private final SessionFactory sessionFactory;
        private final Mode mode;
        private Function<List<Long>, List<T>> function;
        private Function<List<T>, List<T>> saver;
        private List<T> entity;
        private List<Long> keys;
        private List<Function<List<T>, Void>> operations = Lists.newArrayList();

        public BatchLockedContext(SessionFactory sessionFactory, Function<List<Long>, List<T>> getter, List<Long> keys, boolean read) {
            this.sessionFactory = sessionFactory;
            this.function = getter;
            this.keys = keys;
            this.mode = Mode.READ;
        }

        public BatchLockedContext(SessionFactory sessionFactory, Function<List<T>, List<T>> saver, List<T> entity) {
            this.sessionFactory = sessionFactory;
            this.saver = saver;
            this.entity = entity;
            this.mode = Mode.INSERT;
        }

        public BatchLockedContext<T> mutate(Mutator<T> mutator) {
            return this.apply(parent -> {
                mutator.mutator((List)parent);
                return null;
            });
        }

        public BatchLockedContext<T> apply(Function<List<T>, Void> handler) {
            this.operations.add(handler);
            return this;
        }

        public <U> BatchLockedContext<T> saveAll(LookupDao<U> lookupDao, Function<List<T>, List<U>> entityGenerator, BiFunction<List<U>, List<T>, Void> postPersistHandler) {
            return this.apply(parent -> {
                try {
                    List entities = (List)entityGenerator.apply((List)parent);
                    for (Object entity : entities) {
                        lookupDao.save(entity);
                    }
                    postPersistHandler.apply(entities, (List)parent);
                }
                catch (Exception e) {
                    throw new DaoException(e);
                }
                return null;
            });
        }

        public <U> BatchLockedContext<T> saveSingle(LookupDao<U> lookupDao, Function<List<T>, Optional<U>> entityGenerator, BiFunction<Optional<U>, List<T>, Void> postPersistHandler) {
            return this.apply(parent -> {
                try {
                    Optional entity = (Optional)entityGenerator.apply((List)parent);
                    if (entity.isPresent()) {
                        lookupDao.save(entity.get());
                    }
                    postPersistHandler.apply(entity, (List)parent);
                }
                catch (Exception e) {
                    throw new DaoException(e);
                }
                return null;
            });
        }

        public List<T> execute() {
            TransactionHandler transactionHandler = new TransactionHandler(this.sessionFactory, false);
            transactionHandler.beforeStart();
            try {
                List result = this.generateEntity();
                this.operations.forEach(operation -> operation.apply(result));
                List list = result;
                return list;
            }
            catch (Exception e) {
                transactionHandler.onError(e);
                throw e;
            }
            finally {
                transactionHandler.afterEnd();
            }
        }

        private List<T> generateEntity() {
            List<T> result = null;
            switch (this.mode) {
                case READ: {
                    result = this.function.apply(this.keys);
                    if (result != null) break;
                    throw new DaoException("Entity doesn't exist for keys: " + this.keys);
                }
                case INSERT: {
                    result = this.saver.apply(this.entity);
                    break;
                }
            }
            return result;
        }

        @Generated
        public SessionFactory getSessionFactory() {
            return this.sessionFactory;
        }

        @Generated
        public Mode getMode() {
            return this.mode;
        }

        @Generated
        public Function<List<Long>, List<T>> getFunction() {
            return this.function;
        }

        @Generated
        public Function<List<T>, List<T>> getSaver() {
            return this.saver;
        }

        @Generated
        public List<T> getEntity() {
            return this.entity;
        }

        @Generated
        public List<Long> getKeys() {
            return this.keys;
        }

        @Generated
        public List<Function<List<T>, Void>> getOperations() {
            return this.operations;
        }

        @FunctionalInterface
        public static interface Mutator<T> {
            public void mutator(List<T> var1);
        }

        static enum Mode {
            READ,
            INSERT;

        }
    }

    public static class LockedContext<T> {
        private final SessionFactory sessionFactory;
        private final Mode mode;
        private Function<Long, T> function;
        private Function<T, T> saver;
        private T entity;
        private Long key;
        private List<Function<T, Void>> operations = Lists.newArrayList();

        public LockedContext(SessionFactory sessionFactory, Function<Long, T> getter, Long key) {
            this.sessionFactory = sessionFactory;
            this.function = getter;
            this.key = key;
            this.mode = Mode.READ;
        }

        public LockedContext(SessionFactory sessionFactory, Function<T, T> saver, T entity) {
            this.sessionFactory = sessionFactory;
            this.saver = saver;
            this.entity = entity;
            this.mode = Mode.INSERT;
        }

        public LockedContext<T> mutate(Mutator<T> mutator) {
            return this.apply(parent -> {
                mutator.mutator(parent);
                return null;
            });
        }

        public LockedContext<T> apply(Function<T, Void> handler) {
            this.operations.add(handler);
            return this;
        }

        public <U> LockedContext<T> save(LookupDao<U> lookupDao, Function<T, U> entityGenerator) {
            return this.apply(parent -> {
                try {
                    Object applied = entityGenerator.apply(parent);
                    lookupDao.save(applied);
                }
                catch (Exception e) {
                    throw new DaoException(e);
                }
                return null;
            });
        }

        public <U> LockedContext<T> saveAll(LookupDao<U> lookupDao, Function<T, List<U>> entityGenerator) {
            return this.apply(parent -> {
                try {
                    List entities = (List)entityGenerator.apply(parent);
                    for (Object e : entities) {
                        lookupDao.save(e);
                    }
                }
                catch (Exception e) {
                    throw new DaoException(e);
                }
                return null;
            });
        }

        public <U> LockedContext<T> update(LookupDao<U> lookupDao, Long id, Function<Optional<U>, U> handler) {
            return this.apply(parent -> {
                try {
                    lookupDao.update(id, handler);
                }
                catch (Exception e) {
                    throw new DaoException(e);
                }
                return null;
            });
        }

        public <U> LockedContext<T> update(LookupDao<U> lookupDao, String query, Map<String, Object> params) {
            return this.apply(parent -> {
                try {
                    int result = lookupDao.update(query, params);
                    if (result < 1) {
                        throw new DaoException("Update operation returned result " + result);
                    }
                }
                catch (Exception e) {
                    throw new DaoException(e);
                }
                return null;
            });
        }

        public LockedContext<T> filter(Predicate<T> predicate) {
            return this.filter(predicate, new IllegalArgumentException("Predicate check failed"));
        }

        public LockedContext<T> filter(Predicate<T> predicate, RuntimeException failureException) {
            return this.apply(parent -> {
                boolean result = predicate.test(parent);
                if (!result) {
                    throw failureException;
                }
                return null;
            });
        }

        public T execute() {
            TransactionHandler transactionHandler = new TransactionHandler(this.sessionFactory, false);
            transactionHandler.beforeStart();
            try {
                Object result = this.generateEntity();
                this.operations.forEach(operation -> operation.apply(result));
                Object t = result;
                return t;
            }
            catch (Exception e) {
                transactionHandler.onError(e);
                throw e;
            }
            finally {
                transactionHandler.afterEnd();
            }
        }

        private T generateEntity() {
            T result = null;
            switch (this.mode) {
                case READ: {
                    result = this.function.apply(this.key);
                    if (result != null) break;
                    throw new DaoException("Entity doesn't exist for keys: " + this.key);
                }
                case INSERT: {
                    result = this.saver.apply(this.entity);
                    break;
                }
            }
            return result;
        }

        @Generated
        public SessionFactory getSessionFactory() {
            return this.sessionFactory;
        }

        @Generated
        public Mode getMode() {
            return this.mode;
        }

        @Generated
        public Function<Long, T> getFunction() {
            return this.function;
        }

        @Generated
        public Function<T, T> getSaver() {
            return this.saver;
        }

        @Generated
        public T getEntity() {
            return this.entity;
        }

        @Generated
        public Long getKey() {
            return this.key;
        }

        @Generated
        public List<Function<T, Void>> getOperations() {
            return this.operations;
        }

        @FunctionalInterface
        public static interface Mutator<T> {
            public void mutator(T var1);
        }

        static enum Mode {
            READ,
            INSERT;

        }
    }

    private static class AggregateParams {
        private DetachedCriteria criteria;
        private String propertyName;

        @Generated
        AggregateParams(DetachedCriteria criteria, String propertyName) {
            this.criteria = criteria;
            this.propertyName = propertyName;
        }

        @Generated
        public static AggregateParamsBuilder builder() {
            return new AggregateParamsBuilder();
        }

        @Generated
        public DetachedCriteria getCriteria() {
            return this.criteria;
        }

        @Generated
        public String getPropertyName() {
            return this.propertyName;
        }

        @Generated
        public void setCriteria(DetachedCriteria criteria) {
            this.criteria = criteria;
        }

        @Generated
        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AggregateParams)) {
                return false;
            }
            AggregateParams other = (AggregateParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DetachedCriteria this$criteria = this.getCriteria();
            DetachedCriteria other$criteria = other.getCriteria();
            if (this$criteria == null ? other$criteria != null : !this$criteria.equals(other$criteria)) {
                return false;
            }
            String this$propertyName = this.getPropertyName();
            String other$propertyName = other.getPropertyName();
            return !(this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AggregateParams;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DetachedCriteria $criteria = this.getCriteria();
            result = result * 59 + ($criteria == null ? 43 : $criteria.hashCode());
            String $propertyName = this.getPropertyName();
            result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LookupDao.AggregateParams(criteria=" + this.getCriteria() + ", propertyName=" + this.getPropertyName() + ")";
        }

        @Generated
        public static class AggregateParamsBuilder {
            @Generated
            private DetachedCriteria criteria;
            @Generated
            private String propertyName;

            @Generated
            AggregateParamsBuilder() {
            }

            @Generated
            public AggregateParamsBuilder criteria(DetachedCriteria criteria) {
                this.criteria = criteria;
                return this;
            }

            @Generated
            public AggregateParamsBuilder propertyName(String propertyName) {
                this.propertyName = propertyName;
                return this;
            }

            @Generated
            public AggregateParams build() {
                return new AggregateParams(this.criteria, this.propertyName);
            }

            @Generated
            public String toString() {
                return "LookupDao.AggregateParams.AggregateParamsBuilder(criteria=" + this.criteria + ", propertyName=" + this.propertyName + ")";
            }
        }
    }

    private static class QueryParams {
        private String query;
        private Map<String, Object> params;
        private boolean nativeQuery;

        @Generated
        QueryParams(String query, Map<String, Object> params, boolean nativeQuery) {
            this.query = query;
            this.params = params;
            this.nativeQuery = nativeQuery;
        }

        @Generated
        public static QueryParamsBuilder builder() {
            return new QueryParamsBuilder();
        }

        @Generated
        public String getQuery() {
            return this.query;
        }

        @Generated
        public Map<String, Object> getParams() {
            return this.params;
        }

        @Generated
        public boolean isNativeQuery() {
            return this.nativeQuery;
        }

        @Generated
        public void setQuery(String query) {
            this.query = query;
        }

        @Generated
        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        @Generated
        public void setNativeQuery(boolean nativeQuery) {
            this.nativeQuery = nativeQuery;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryParams)) {
                return false;
            }
            QueryParams other = (QueryParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isNativeQuery() != other.isNativeQuery()) {
                return false;
            }
            String this$query = this.getQuery();
            String other$query = other.getQuery();
            if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                return false;
            }
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QueryParams;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isNativeQuery() ? 79 : 97);
            String $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LookupDao.QueryParams(query=" + this.getQuery() + ", params=" + this.getParams() + ", nativeQuery=" + this.isNativeQuery() + ")";
        }

        @Generated
        public static class QueryParamsBuilder {
            @Generated
            private String query;
            @Generated
            private Map<String, Object> params;
            @Generated
            private boolean nativeQuery;

            @Generated
            QueryParamsBuilder() {
            }

            @Generated
            public QueryParamsBuilder query(String query) {
                this.query = query;
                return this;
            }

            @Generated
            public QueryParamsBuilder params(Map<String, Object> params) {
                this.params = params;
                return this;
            }

            @Generated
            public QueryParamsBuilder nativeQuery(boolean nativeQuery) {
                this.nativeQuery = nativeQuery;
                return this;
            }

            @Generated
            public QueryParams build() {
                return new QueryParams(this.query, this.params, this.nativeQuery);
            }

            @Generated
            public String toString() {
                return "LookupDao.QueryParams.QueryParamsBuilder(query=" + this.query + ", params=" + this.params + ", nativeQuery=" + this.nativeQuery + ")";
            }
        }
    }

    private static class CriteriaParams {
        private DetachedCriteria criteria;
        private int limit;
        private int offset;
        private String fetchProfile;

        @Generated
        private static int $default$limit() {
            return -1;
        }

        @Generated
        private static int $default$offset() {
            return -1;
        }

        @Generated
        CriteriaParams(DetachedCriteria criteria, int limit, int offset, String fetchProfile) {
            this.criteria = criteria;
            this.limit = limit;
            this.offset = offset;
            this.fetchProfile = fetchProfile;
        }

        @Generated
        public static CriteriaParamsBuilder builder() {
            return new CriteriaParamsBuilder();
        }

        @Generated
        public DetachedCriteria getCriteria() {
            return this.criteria;
        }

        @Generated
        public int getLimit() {
            return this.limit;
        }

        @Generated
        public int getOffset() {
            return this.offset;
        }

        @Generated
        public String getFetchProfile() {
            return this.fetchProfile;
        }

        @Generated
        public void setCriteria(DetachedCriteria criteria) {
            this.criteria = criteria;
        }

        @Generated
        public void setLimit(int limit) {
            this.limit = limit;
        }

        @Generated
        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Generated
        public void setFetchProfile(String fetchProfile) {
            this.fetchProfile = fetchProfile;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CriteriaParams)) {
                return false;
            }
            CriteriaParams other = (CriteriaParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLimit() != other.getLimit()) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            DetachedCriteria this$criteria = this.getCriteria();
            DetachedCriteria other$criteria = other.getCriteria();
            if (this$criteria == null ? other$criteria != null : !this$criteria.equals(other$criteria)) {
                return false;
            }
            String this$fetchProfile = this.getFetchProfile();
            String other$fetchProfile = other.getFetchProfile();
            return !(this$fetchProfile == null ? other$fetchProfile != null : !this$fetchProfile.equals(other$fetchProfile));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CriteriaParams;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLimit();
            result = result * 59 + this.getOffset();
            DetachedCriteria $criteria = this.getCriteria();
            result = result * 59 + ($criteria == null ? 43 : $criteria.hashCode());
            String $fetchProfile = this.getFetchProfile();
            result = result * 59 + ($fetchProfile == null ? 43 : $fetchProfile.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LookupDao.CriteriaParams(criteria=" + this.getCriteria() + ", limit=" + this.getLimit() + ", offset=" + this.getOffset() + ", fetchProfile=" + this.getFetchProfile() + ")";
        }

        @Generated
        public static class CriteriaParamsBuilder {
            @Generated
            private DetachedCriteria criteria;
            @Generated
            private boolean limit$set;
            @Generated
            private int limit$value;
            @Generated
            private boolean offset$set;
            @Generated
            private int offset$value;
            @Generated
            private String fetchProfile;

            @Generated
            CriteriaParamsBuilder() {
            }

            @Generated
            public CriteriaParamsBuilder criteria(DetachedCriteria criteria) {
                this.criteria = criteria;
                return this;
            }

            @Generated
            public CriteriaParamsBuilder limit(int limit) {
                this.limit$value = limit;
                this.limit$set = true;
                return this;
            }

            @Generated
            public CriteriaParamsBuilder offset(int offset) {
                this.offset$value = offset;
                this.offset$set = true;
                return this;
            }

            @Generated
            public CriteriaParamsBuilder fetchProfile(String fetchProfile) {
                this.fetchProfile = fetchProfile;
                return this;
            }

            @Generated
            public CriteriaParams build() {
                int limit$value = this.limit$value;
                if (!this.limit$set) {
                    limit$value = CriteriaParams.$default$limit();
                }
                int offset$value = this.offset$value;
                if (!this.offset$set) {
                    offset$value = CriteriaParams.$default$offset();
                }
                return new CriteriaParams(this.criteria, limit$value, offset$value, this.fetchProfile);
            }

            @Generated
            public String toString() {
                return "LookupDao.CriteriaParams.CriteriaParamsBuilder(criteria=" + this.criteria + ", limit$value=" + this.limit$value + ", offset$value=" + this.offset$value + ", fetchProfile=" + this.fetchProfile + ")";
            }
        }
    }
}

