(ns

    ^{:doc    "Random utils, common validators."
      :author "Paweł Wilk"
      :added  "1.0.0"}

    io.randomseed.utils.validators.common

  (:import (org.apache.commons.validator.routines EmailValidator
                                                  UrlValidator
                                                  DateValidator)
           (java.util Locale))

  (:require [trptr.java-wrapper.locale :as          l]
            [phone-number.core         :as      phone]
            [io.randomseed.utils       :as          u]))

;;
;; e-mail
;;

(defn valid-email?
  (^Boolean [e]
   (valid-email? e false true))
  (^Boolean [e allow-local]
   (valid-email? e allow-local true))
  (^Boolean [e allow-local allow-tld]
   (boolean
    (when-some [e (u/some-str e)]
      (.isValid ^EmailValidator (EmailValidator/getInstance ^Boolean (boolean allow-local)
                                                            ^Boolean (boolean allow-tld))
                ^String e)))))

;;
;; date
;;

(defn valid-date?
  (^Boolean [value]
   (boolean
    (when-some [value (u/some-str value)]
      (.isValid ^DateValidator (DateValidator/getInstance) ^String value))))
  (^Boolean [value pattern]
   (boolean
    (when-some [value (u/some-str value)]
      (if-some [pattern (u/some-str pattern)]
        (.isValid ^DateValidator (DateValidator/getInstance)
                  ^String value ^String pattern)
        (.isValid ^DateValidator (DateValidator/getInstance)
                  ^String value)))))
  (^Boolean [value pattern locale]
   (boolean
    (when-some [value (u/some-str value)]
      (if-some [pattern (u/some-str pattern)]
        (if locale
          (.isValid ^DateValidator (DateValidator/getInstance)
                    ^String value ^String pattern ^Locale (l/locale locale))
          (.isValid ^DateValidator (DateValidator/getInstance)
                    ^String value ^String pattern))
        (if locale
          (.isValid ^DateValidator (DateValidator/getInstance)
                    ^String value
                    ^Locale (l/locale locale))
          (.isValid ^DateValidator (DateValidator/getInstance)
                    ^String value)))))))

;;
;; phone number
;;

(defn valid-phone?
  (^Boolean [p]    (phone/valid? p))
  (^Boolean [p dr] (phone/valid? p dr)))

(defn valid-regular-phone?
  (^Boolean [p]
   (and (phone/valid? p)
        (not (let [pn (phone/number p)]
               (or (phone/is-short? pn)
                   (contains? #{:phone-number.type/toll-free
                                :phone-number.type/premium-rate
                                :phone-number.type/shared-cost}
                              (phone/type pn)))))))
  (^Boolean [p dr]
   (and (phone/valid? p dr)
        (not (let [pn (phone/number p dr)]
               (or (phone/is-short? pn)
                   (contains? #{:phone-number.type/toll-free
                                :phone-number.type/premium-rate
                                :phone-number.type/shared-cost}
                              (phone/type pn))))))))

;;
;; url
;;

(defn valid-url?
  ^Boolean [u]
  (boolean
   (when-some [u (u/some-str u)]
     (.isValid ^UrlValidator (UrlValidator/getInstance) ^String u))))
