/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.optimizer.hystrix;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum ThreadPoolMetric {
    ROLLING_MAX_ACTIVE_THREADS("rollingMaxActiveThreads"),
    PROPERTY_VALUE_MAXIMUM_SIZE("propertyValue_maximumSize");

    private static final Map<String, ThreadPoolMetric> lookup;
    String metricName;

    private ThreadPoolMetric(String metricName) {
        this.metricName = metricName;
    }

    public static ThreadPoolMetric get(String metricName) {
        return lookup.get(metricName);
    }

    public static Set<String> metrics() {
        return lookup.keySet();
    }

    public String getMetricName() {
        return this.metricName;
    }

    static {
        lookup = new HashMap<String, ThreadPoolMetric>();
        for (ThreadPoolMetric s : EnumSet.allOf(ThreadPoolMetric.class)) {
            lookup.put(s.getMetricName(), s);
        }
    }
}

