/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.confighandler;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.revolver.RevolverBundle;
import io.dropwizard.revolver.confighandler.ConfigUpdateEventListener;
import io.dropwizard.revolver.core.RevolverContextFactory;
import io.dropwizard.revolver.core.config.RevolverConfig;
import io.dropwizard.revolver.core.config.RevolverConfigHolder;
import io.dropwizard.revolver.core.model.RevolverExecutorType;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevolverConfigUpdateEventListener
extends ConfigUpdateEventListener {
    private static final Logger log = LoggerFactory.getLogger(RevolverConfigUpdateEventListener.class);
    private ObjectMapper objectMapper;
    private RevolverConfigHolder revolverConfigHolder;

    public RevolverConfigUpdateEventListener(String configAttribute, ObjectMapper objectMapper, RevolverConfigHolder configHolder) {
        super(configAttribute);
        this.objectMapper = objectMapper.copy();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.revolverConfigHolder = configHolder;
    }

    @Override
    protected void reloadConfig(String configString) {
        try {
            RevolverConfig revolverConfig = (RevolverConfig)this.objectMapper.readValue(configString, RevolverConfig.class);
            this.revolverConfigHolder.setConfig(revolverConfig);
            this.configUpdated(revolverConfig);
        }
        catch (IOException e) {
            log.error("Error reloading revolver config: ", (Throwable)e);
        }
    }

    public synchronized void configUpdated(RevolverConfig revolverConfig) {
        RevolverContextFactory revolverContextFactory = RevolverBundle.revolverContextFactory;
        for (RevolverExecutorType revolverExecutorType : RevolverExecutorType.values()) {
            revolverContextFactory.getContext(revolverExecutorType).reload(revolverConfig);
        }
        RevolverBundle.loadServiceConfiguration(revolverConfig);
    }
}

