/*
 * Decompiled with CFR 0.152.
 */
package io.phonepe.hystrixoptimizer.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DiffHelper<T> {
    private static final Logger log = LoggerFactory.getLogger(DiffHelper.class);
    private ObjectMapper mapper;

    public DiffHelper(ObjectMapper objectMapper) {
        this.mapper = objectMapper;
    }

    public String getObjectDiff(T baseObject, T currentObject) {
        try {
            ArrayList<String> diffString = new ArrayList<String>();
            TypeReference<HashMap<String, Object>> type = new TypeReference<HashMap<String, Object>>(){};
            Map leftMap = (Map)this.mapper.readValue(this.mapper.writeValueAsString(baseObject), (TypeReference)type);
            Map rightMap = (Map)this.mapper.readValue(this.mapper.writeValueAsString(currentObject), (TypeReference)type);
            Map<String, Object> leftFlatMap = DiffHelper.flatten(leftMap);
            Map<String, Object> rightFlatMap = DiffHelper.flatten(rightMap);
            MapDifference difference = Maps.difference(leftFlatMap, rightFlatMap);
            difference.entriesOnlyOnLeft().forEach((key, value) -> diffString.add(key + ": " + value + '\n'));
            difference.entriesOnlyOnRight().forEach((key, value) -> diffString.add(key + ": " + value + '\n'));
            diffString.add("\n\nEntries differing\n--------------------------\n");
            difference.entriesDiffering().forEach((key, value) -> diffString.add(key + ": " + value + '\n'));
            return String.join((CharSequence)"", diffString);
        }
        catch (Exception e) {
            log.error("Exception while calculating difference. Only logging it.");
            return null;
        }
    }

    private static Map<String, Object> flatten(Map<String, Object> map) {
        return map.entrySet().stream().flatMap(DiffHelper::flatten).collect(LinkedHashMap::new, (m, e) -> m.put("/" + (String)e.getKey(), e.getValue()), HashMap::putAll);
    }

    private static Stream<Map.Entry<String, Object>> flatten(Map.Entry<String, Object> entry) {
        if (entry == null) {
            return Stream.empty();
        }
        if (entry.getValue() instanceof Map) {
            return ((Map)entry.getValue()).entrySet().stream().flatMap(e -> DiffHelper.flatten(new AbstractMap.SimpleEntry<String, Object>((String)entry.getKey() + "/" + e.getKey(), e.getValue())));
        }
        if (entry.getValue() instanceof List) {
            List list = (List)entry.getValue();
            return IntStream.range(0, list.size()).mapToObj(i -> new AbstractMap.SimpleEntry((String)entry.getKey() + "/" + i, list.get(i))).flatMap(DiffHelper::flatten);
        }
        return Stream.of(entry);
    }
}

