/*
 * Decompiled with CFR 0.152.
 */
package io.phonepe.hystrixoptimizer.email;

import io.phonepe.hystrixoptimizer.config.actions.impl.EmailConfig;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.inject.Singleton;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EmailClient {
    private static final Logger log = LoggerFactory.getLogger(EmailClient.class);
    private final Session mailSession;
    private final EmailConfig mailConfig;

    public EmailClient(EmailConfig emailConfig) {
        this.mailConfig = emailConfig;
        Properties mailProps = new Properties();
        mailProps.put("mail.transport.protocol", "smtp");
        mailProps.put("mail.smtp.host", this.mailConfig.getHost());
        mailProps.put("mail.smtp.port", this.mailConfig.getPort());
        mailProps.put("mail.smtp.auth", (Object)false);
        mailProps.put("mail.smtp.startttls.enable", (Object)false);
        mailProps.put("mail.smtp.timeout", (Object)10000);
        mailProps.put("mail.smtp.connectiontimeout", (Object)10000);
        this.mailSession = Session.getDefaultInstance((Properties)mailProps);
    }

    public void sendEmail(String emailIds, String subject, String messageBody) {
        try {
            MimeMessage message = new MimeMessage(this.mailSession);
            message.setFrom((Address)new InternetAddress(this.mailConfig.getFrom()));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)emailIds));
            message.setSubject(subject);
            InternetHeaders headers = new InternetHeaders();
            headers.addHeader("Content-type", "text/html; charset=UTF-8");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)new MimeBodyPart(headers, messageBody.getBytes(StandardCharsets.UTF_8)));
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
        }
        catch (Exception e) {
            log.error("Error while sending email alert.");
        }
    }
}

