/*
 * Decompiled with CFR 0.152.
 */
package io.phonepe.hystrixoptimizer.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.hystrix.configurator.config.CommandThreadPoolConfig;
import com.hystrix.configurator.config.HystrixCommandConfig;
import com.hystrix.configurator.config.HystrixConfig;
import com.hystrix.configurator.config.ThreadPoolConfig;
import com.hystrix.configurator.core.HystrixConfigurationFactory;
import io.phonepe.hystrixoptimizer.config.OptimizerConcurrencyConfig;
import io.phonepe.hystrixoptimizer.config.OptimizerConfig;
import io.phonepe.hystrixoptimizer.config.OptimizerTimeConfig;
import io.phonepe.hystrixoptimizer.config.actions.Actions;
import io.phonepe.hystrixoptimizer.config.actions.impl.EmailConfig;
import io.phonepe.hystrixoptimizer.config.actions.impl.UpdateHystrixConfig;
import io.phonepe.hystrixoptimizer.core.OptimizerCacheKey;
import io.phonepe.hystrixoptimizer.core.OptimizerMetricsCache;
import io.phonepe.hystrixoptimizer.email.EmailClient;
import io.phonepe.hystrixoptimizer.metrics.AggregationAlgo;
import io.phonepe.hystrixoptimizer.metrics.LatencyMetric;
import io.phonepe.hystrixoptimizer.metrics.ThreadPoolMetric;
import io.phonepe.hystrixoptimizer.models.ActionType;
import io.phonepe.hystrixoptimizer.models.OptimalThreadPoolAttributes;
import io.phonepe.hystrixoptimizer.models.OptimalTimeoutAttributes;
import io.phonepe.hystrixoptimizer.models.OptimizerAggregatedMetric;
import io.phonepe.hystrixoptimizer.models.OptimizerMetrics;
import io.phonepe.hystrixoptimizer.utils.ActionTypeVisitor;
import io.phonepe.hystrixoptimizer.utils.DiffHelper;
import io.phonepe.hystrixoptimizer.utils.EmailUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixConfigUpdater
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(HystrixConfigUpdater.class);
    private HystrixConfig hystrixConfig;
    private HystrixConfig initialHystrixConfig;
    private OptimizerConfig optimizerConfig;
    private OptimizerMetricsCache optimizerMetricsCache;
    private Map<String, HystrixCommandConfig> initialHystrixCommandConfigMap;
    private Actions allowedActions;
    private EmailClient emailClient;
    private DiffHelper<HystrixConfig> diffHelper;
    public static final String GLOBAL_THREAD_POOL_PREFIX = "global_";

    public HystrixConfigUpdater(HystrixConfig hystrixConfig, HystrixConfig initialHystrixConfig, OptimizerConfig optimizerConfig, OptimizerMetricsCache optimizerMetricsCache, Actions allowedActions) {
        this.hystrixConfig = hystrixConfig;
        this.initialHystrixConfig = initialHystrixConfig;
        this.optimizerConfig = optimizerConfig;
        this.optimizerMetricsCache = optimizerMetricsCache;
        this.initialHystrixCommandConfigMap = Maps.newHashMap();
        this.initialHystrixConfig.getCommands().forEach(hystrixCommandConfig -> this.initialHystrixCommandConfigMap.putIfAbsent(hystrixCommandConfig.getName(), (HystrixCommandConfig)hystrixCommandConfig));
        this.diffHelper = new DiffHelper(new ObjectMapper());
        if (allowedActions.getActionConfigs().stream().anyMatch(actionConfig -> actionConfig.getActionType() == ActionType.SEND_EMAIL_ALERT)) {
            EmailConfig emailConfig = EmailUtil.getEmailConfig(allowedActions);
            Preconditions.checkNotNull((Object)emailConfig, (Object)"Email Config cannot be null");
            this.emailClient = new EmailClient(emailConfig);
        }
    }

    @Override
    public void run() {
        try {
            log.info("Running hystrix config updater job with exception catching enabled");
            Map<OptimizerCacheKey, OptimizerMetrics> metricsCache = this.optimizerMetricsCache.getCache();
            if (metricsCache.isEmpty()) {
                log.info("Metrics cache is empty");
                return;
            }
            HashMap aggregatedAppLatencyMetrics = Maps.newHashMap();
            HashMap apiLevelThreadPoolMetrics = Maps.newHashMap();
            HashMap aggregateApiLevelLatencyMetrics = Maps.newHashMap();
            metricsCache.forEach((key, optimizerMetrics) -> optimizerMetrics.getMetrics().forEach((metric, value) -> {
                this.aggregateAppLevelLatencyMetrics(aggregatedAppLatencyMetrics, (String)metric, (Number)value);
                this.aggregateApiLevelMetrics(apiLevelThreadPoolMetrics, aggregateApiLevelLatencyMetrics, (String)metric, (Number)value, (OptimizerCacheKey)key);
            }));
            log.debug("Aggregated API Level Latency Metrics: {}", (Object)aggregateApiLevelLatencyMetrics);
            Map<String, OptimizerMetrics> apiLevelLatencyMetrics = this.avgApiLevelLatencyMetrics(aggregateApiLevelLatencyMetrics);
            log.debug("API Level Latency Metrics: {}", apiLevelLatencyMetrics);
            this.updateHystrixConfig(apiLevelThreadPoolMetrics, apiLevelLatencyMetrics);
        }
        catch (Exception e) {
            log.error("Hystrix config couldn't be updated : " + e);
        }
    }

    private Map<String, OptimizerMetrics> avgApiLevelLatencyMetrics(Map<String, Map<String, OptimizerAggregatedMetric>> aggregatedLatencyMetrics) {
        HashMap aggregateApiLevelLatencyMetrics = Maps.newHashMap();
        aggregatedLatencyMetrics.forEach((keyName, latencyMetricMap) -> {
            if (!aggregateApiLevelLatencyMetrics.containsKey(keyName)) {
                aggregateApiLevelLatencyMetrics.put(keyName, OptimizerMetrics.builder().metrics(Maps.newHashMap()).build());
            }
            latencyMetricMap.forEach((metric, aggregateMetric) -> ((OptimizerMetrics)aggregateApiLevelLatencyMetrics.get(keyName)).getMetrics().put((String)metric, aggregateMetric.getSum() / aggregateMetric.getCount()));
        });
        return aggregateApiLevelLatencyMetrics;
    }

    private void aggregateAppLevelLatencyMetrics(Map<String, OptimizerAggregatedMetric> aggregatedAppLatencyMetrics, String metric, Number value) {
        OptimizerTimeConfig optimizerTimeConfig = this.optimizerConfig.getTimeConfig();
        if (optimizerTimeConfig == null || !optimizerTimeConfig.isEnabled() || !optimizerTimeConfig.getLatencyMetrics().contains((Object)LatencyMetric.valueOf(metric)) || value.intValue() == 0) {
            return;
        }
        if (!aggregatedAppLatencyMetrics.containsKey(metric)) {
            aggregatedAppLatencyMetrics.put(metric, OptimizerAggregatedMetric.builder().sum(0L).count(0L).build());
        }
        OptimizerAggregatedMetric optimizerAggregatedMetrics = aggregatedAppLatencyMetrics.get(metric);
        optimizerAggregatedMetrics.setSum(optimizerAggregatedMetrics.getSum() + value.longValue());
        optimizerAggregatedMetrics.setCount(optimizerAggregatedMetrics.getCount() + 1L);
        aggregatedAppLatencyMetrics.forEach((metricName, aggregatedAppMetrics) -> log.info("Aggregated " + metricName + " for app: " + aggregatedAppMetrics.getSum() / aggregatedAppMetrics.getCount()));
    }

    private void aggregateApiLevelMetrics(Map<String, OptimizerMetrics> apiLevelThreadPoolMetrics, Map<String, Map<String, OptimizerAggregatedMetric>> aggregateApiLevelLatencyMetrics, String metric, Number value, OptimizerCacheKey key) {
        AggregationAlgo aggregationAlgo = key.getMetricType().getAggregationAlgo();
        switch (aggregationAlgo) {
            case MAX: {
                Map<String, Number> threadPoolMetricsMap = this.getThreadPoolMetricsMap(apiLevelThreadPoolMetrics, key);
                if (threadPoolMetricsMap.containsKey(metric) && threadPoolMetricsMap.get(metric).intValue() >= value.intValue()) break;
                threadPoolMetricsMap.put(metric, value);
                break;
            }
            case AVG: {
                OptimizerAggregatedMetric optimizerAggregatedMetric = this.getAggregateMetricsMap(aggregateApiLevelLatencyMetrics, key, metric);
                optimizerAggregatedMetric.setSum(optimizerAggregatedMetric.getSum() + value.longValue());
                optimizerAggregatedMetric.setCount(optimizerAggregatedMetric.getCount() + 1L);
            }
        }
    }

    private Map<String, Number> getThreadPoolMetricsMap(Map<String, OptimizerMetrics> maxedThreadPoolMetrics, OptimizerCacheKey key) {
        if (!maxedThreadPoolMetrics.containsKey(key.getName())) {
            maxedThreadPoolMetrics.put(key.getName(), OptimizerMetrics.builder().metrics(Maps.newHashMap()).build());
        }
        OptimizerMetrics optimizerAggregatedMetrics = maxedThreadPoolMetrics.get(key.getName());
        return optimizerAggregatedMetrics.getMetrics();
    }

    private OptimizerAggregatedMetric getAggregateMetricsMap(Map<String, Map<String, OptimizerAggregatedMetric>> aggregatedMetrics, OptimizerCacheKey key, String metric) {
        if (!aggregatedMetrics.containsKey(key.getName())) {
            aggregatedMetrics.put(key.getName(), Maps.newHashMap());
        }
        if (!aggregatedMetrics.get(key.getName()).containsKey(metric)) {
            aggregatedMetrics.get(key.getName()).put(metric, OptimizerAggregatedMetric.builder().sum(0L).count(0L).build());
        }
        return aggregatedMetrics.get(key.getName()).get(metric);
    }

    private void updateHystrixConfig(Map<String, OptimizerMetrics> apiLevelThreadPoolMetrics, Map<String, OptimizerMetrics> apiLevelLatencyMetrics) {
        AtomicBoolean configUpdated = new AtomicBoolean();
        this.updateHystrixConfigForThreadPoolGroups(apiLevelThreadPoolMetrics, configUpdated);
        this.updateHystrixConfigForCommands(apiLevelThreadPoolMetrics, apiLevelLatencyMetrics, configUpdated);
        List<HystrixCommandConfig> hystrixCommandConfigs = this.updateHystrixConfigForCommandsWithDefaultConfig(apiLevelThreadPoolMetrics, apiLevelLatencyMetrics, configUpdated);
        if (configUpdated.get()) {
            this.takeAction(hystrixCommandConfigs);
        }
    }

    private List<HystrixCommandConfig> updateHystrixConfigForCommandsWithDefaultConfig(Map<String, OptimizerMetrics> apiLevelThreadPoolMetrics, Map<String, OptimizerMetrics> apiLevelLatencyMetrics, AtomicBoolean configUpdated) {
        List hystrixCommandConfigs = this.hystrixConfig.getCommands();
        Set existingCommandConfigKeys = this.hystrixConfig.getCommands().stream().map(HystrixCommandConfig::getName).collect(Collectors.toSet());
        apiLevelLatencyMetrics.keySet().stream().filter(keyName -> !existingCommandConfigKeys.contains(keyName)).forEach(commandName -> {
            OptimizerMetrics optimizerLatencyMetrics = (OptimizerMetrics)apiLevelLatencyMetrics.get(commandName);
            OptimizerMetrics optimizerThreadPoolMetrics = (OptimizerMetrics)apiLevelThreadPoolMetrics.get(commandName);
            if (optimizerLatencyMetrics == null || optimizerThreadPoolMetrics == null) {
                return;
            }
            int concurrency = this.hystrixConfig.getDefaultConfig().getThreadPool().getConcurrency();
            OptimalThreadPoolAttributes optimalThreadPoolAttributes = this.calculateOptimalThreadPoolSize(concurrency, concurrency, (String)commandName, optimizerThreadPoolMetrics);
            OptimalTimeoutAttributes optimalTimeoutAttributes = this.calculateOptimalTimeout(this.hystrixConfig.getDefaultConfig().getThreadPool().getTimeout(), optimizerLatencyMetrics);
            log.info("Setting concurrency for : " + commandName + " from : " + this.hystrixConfig.getDefaultConfig().getThreadPool().getConcurrency() + " to : " + optimalThreadPoolAttributes.getOptimalConcurrency() + ", maxRollingActiveThreads : " + optimalThreadPoolAttributes.getMaxRollingActiveThreads());
            log.info("Setting timeout for : " + commandName + " from : " + this.hystrixConfig.getDefaultConfig().getThreadPool().getTimeout() + " to : " + optimalTimeoutAttributes.getOptimalTimeout() + ", meanTimeoutValue : " + optimalTimeoutAttributes.getMeanTimeout() + ", with timeout buffer : " + optimalTimeoutAttributes.getTimeoutBuffer());
            HystrixCommandConfig hystrixCommandConfig = HystrixCommandConfig.builder().name(commandName).threadPool(CommandThreadPoolConfig.builder().concurrency(optimalThreadPoolAttributes.getOptimalConcurrency()).timeout(optimalTimeoutAttributes.getOptimalTimeout()).build()).build();
            hystrixCommandConfigs.add(hystrixCommandConfig);
            configUpdated.set(true);
        });
        return hystrixCommandConfigs;
    }

    private void updateHystrixConfigForCommands(Map<String, OptimizerMetrics> apiLevelThreadPoolMetrics, Map<String, OptimizerMetrics> apiLevelLatencyMetrics, AtomicBoolean configUpdated) {
        this.hystrixConfig.getCommands().forEach(hystrixCommandConfig -> {
            HystrixCommandConfig initialHystrixCommandConfig = this.initialHystrixCommandConfigMap.get(hystrixCommandConfig.getName());
            int initialConcurrency = initialHystrixCommandConfig != null ? initialHystrixCommandConfig.getThreadPool().getConcurrency() : this.initialHystrixConfig.getDefaultConfig().getThreadPool().getConcurrency();
            this.updateApiSettings((HystrixCommandConfig)hystrixCommandConfig, initialConcurrency, apiLevelThreadPoolMetrics, apiLevelLatencyMetrics, configUpdated);
        });
    }

    private void updateHystrixConfigForThreadPoolGroups(Map<String, OptimizerMetrics> apiLevelThreadPoolMetrics, AtomicBoolean configUpdated) {
        this.hystrixConfig.getPools().forEach((poolName, currentThreadPoolConfig) -> {
            OptimizerMetrics optimizerThreadPoolMetrics = (OptimizerMetrics)apiLevelThreadPoolMetrics.get(GLOBAL_THREAD_POOL_PREFIX + poolName);
            ThreadPoolConfig initialThreadPoolConfig = (ThreadPoolConfig)this.initialHystrixConfig.getPools().get(poolName);
            Preconditions.checkArgument((initialThreadPoolConfig != null ? 1 : 0) != 0, (Object)("Initial thread pool config for pool name : " + poolName + " is null"));
            this.updateConcurrencySettingForPool((ThreadPoolConfig)currentThreadPoolConfig, initialThreadPoolConfig, optimizerThreadPoolMetrics, (String)poolName, configUpdated);
        });
    }

    private void updateApiSettings(HystrixCommandConfig hystrixCommandConfig, int initialConcurrency, Map<String, OptimizerMetrics> apiLevelThreadPoolMetrics, Map<String, OptimizerMetrics> apiLevelLatencyMetrics, AtomicBoolean configUpdated) {
        String commandName = hystrixCommandConfig.getName();
        OptimizerMetrics optimizerLatencyMetrics = apiLevelLatencyMetrics.get(commandName);
        OptimizerMetrics optimizerThreadPoolMetrics = apiLevelThreadPoolMetrics.get(commandName);
        if (optimizerLatencyMetrics == null || optimizerThreadPoolMetrics == null) {
            return;
        }
        this.updateConcurrencySettingForCommand(hystrixCommandConfig.getThreadPool(), initialConcurrency, optimizerThreadPoolMetrics, commandName, configUpdated);
        this.updateTimeoutSettingForCommand(hystrixCommandConfig.getThreadPool(), optimizerLatencyMetrics, commandName, configUpdated);
    }

    private void updateConcurrencySettingForCommand(CommandThreadPoolConfig threadPoolConfig, int initialConcurrency, OptimizerMetrics optimizerThreadPoolMetrics, String poolName, AtomicBoolean configUpdated) {
        OptimalThreadPoolAttributes optimalThreadPoolAttributes = this.calculateOptimalThreadPoolSize(threadPoolConfig.getConcurrency(), initialConcurrency, poolName, optimizerThreadPoolMetrics);
        if (optimalThreadPoolAttributes.getOptimalConcurrency() != threadPoolConfig.getConcurrency()) {
            log.info("Setting concurrency for command : " + poolName + " from : " + threadPoolConfig.getConcurrency() + " to : " + optimalThreadPoolAttributes.getOptimalConcurrency() + ", maxRollingActiveThreads : " + optimalThreadPoolAttributes.getMaxRollingActiveThreads());
            threadPoolConfig.setConcurrency(optimalThreadPoolAttributes.getOptimalConcurrency());
            configUpdated.set(true);
        }
    }

    private void updateConcurrencySettingForPool(ThreadPoolConfig currentThreadPoolConfig, ThreadPoolConfig initialThreadPoolConfig, OptimizerMetrics optimizerThreadPoolMetrics, String poolName, AtomicBoolean configUpdated) {
        OptimalThreadPoolAttributes optimalThreadPoolAttributes = this.calculateOptimalThreadPoolSize(currentThreadPoolConfig.getConcurrency(), initialThreadPoolConfig.getConcurrency(), poolName, optimizerThreadPoolMetrics);
        if (optimalThreadPoolAttributes.getOptimalConcurrency() != currentThreadPoolConfig.getConcurrency()) {
            log.info("Setting concurrency for pool : " + poolName + " from : " + currentThreadPoolConfig.getConcurrency() + " to : " + optimalThreadPoolAttributes.getOptimalConcurrency() + ", maxRollingActiveThreads : " + optimalThreadPoolAttributes.getMaxRollingActiveThreads());
            currentThreadPoolConfig.setConcurrency(optimalThreadPoolAttributes.getOptimalConcurrency());
            configUpdated.set(true);
        }
    }

    private void updateTimeoutSettingForCommand(CommandThreadPoolConfig threadPoolConfig, OptimizerMetrics optimizerLatencyMetrics, String commandName, AtomicBoolean configUpdated) {
        OptimalTimeoutAttributes optimalTimeoutAttributes = this.calculateOptimalTimeout(threadPoolConfig.getTimeout(), optimizerLatencyMetrics);
        if (optimalTimeoutAttributes.getOptimalTimeout() != threadPoolConfig.getTimeout()) {
            threadPoolConfig.setTimeout(optimalTimeoutAttributes.getOptimalTimeout());
            configUpdated.set(true);
            log.info("Setting timeout for : " + commandName + " from : " + threadPoolConfig.getTimeout() + " to : " + optimalTimeoutAttributes.getOptimalTimeout() + ", meanTimeoutValue : " + optimalTimeoutAttributes.getMeanTimeout() + ", with timeout buffer : " + optimalTimeoutAttributes.getTimeoutBuffer());
        }
    }

    private OptimalThreadPoolAttributes calculateOptimalThreadPoolSize(int currentConcurrency, int initialConcurrency, String poolName, OptimizerMetrics optimizerThreadPoolMetrics) {
        OptimalThreadPoolAttributes.OptimalThreadPoolAttributesBuilder initialConcurrencyAttrBuilder = OptimalThreadPoolAttributes.builder().optimalConcurrency(currentConcurrency);
        OptimizerConcurrencyConfig concurrencyConfig = this.optimizerConfig.getConcurrencyConfig();
        if (concurrencyConfig == null || !concurrencyConfig.isEnabled() || !optimizerThreadPoolMetrics.getMetrics().containsKey(ThreadPoolMetric.ROLLING_MAX_ACTIVE_THREADS.getMetricName())) {
            return initialConcurrencyAttrBuilder.build();
        }
        int maxRollingActiveThreads = optimizerThreadPoolMetrics.getMetrics().getOrDefault(ThreadPoolMetric.ROLLING_MAX_ACTIVE_THREADS.getMetricName(), 0).intValue();
        log.info("Optimizer Concurrency Settings Enabled : {}, Max Threads Multiplier : {}, Max Threshold : {}, Initial Concurrency : {}, Pool Name: {}", new Object[]{concurrencyConfig.isEnabled(), concurrencyConfig.getMaxThreadsMultiplier(), concurrencyConfig.getMaxThreshold(), currentConcurrency, poolName});
        if (maxRollingActiveThreads == 0) {
            return OptimalThreadPoolAttributes.builder().optimalConcurrency(this.optimizerConfig.getConcurrencyConfig().getDefaultConcurrency()).maxRollingActiveThreads(maxRollingActiveThreads).build();
        }
        if (((double)maxRollingActiveThreads > (double)currentConcurrency * concurrencyConfig.getMaxThreshold() || (double)maxRollingActiveThreads < (double)currentConcurrency * concurrencyConfig.getMinThreshold()) && (double)maxRollingActiveThreads < (double)initialConcurrency * concurrencyConfig.getMaxThreadsMultiplier()) {
            int optimalConcurrency = (int)Math.ceil((double)maxRollingActiveThreads * concurrencyConfig.getBandwidth());
            return OptimalThreadPoolAttributes.builder().optimalConcurrency(optimalConcurrency).maxRollingActiveThreads(maxRollingActiveThreads).build();
        }
        return initialConcurrencyAttrBuilder.maxRollingActiveThreads(maxRollingActiveThreads).build();
    }

    private OptimalTimeoutAttributes calculateOptimalTimeout(int currentTimeout, OptimizerMetrics optimizerLatencyMetrics) {
        OptimalTimeoutAttributes.OptimalTimeoutAttributesBuilder initialTimeoutAttributesBuilder = OptimalTimeoutAttributes.builder().optimalTimeout(currentTimeout);
        OptimizerTimeConfig timeoutConfig = this.optimizerConfig.getTimeConfig();
        if (timeoutConfig == null || !timeoutConfig.isEnabled() || !optimizerLatencyMetrics.getMetrics().containsKey(timeoutConfig.getTimeoutMetric().getMetricName())) {
            return initialTimeoutAttributesBuilder.build();
        }
        int meanTimeoutValue = optimizerLatencyMetrics.getMetrics().get(timeoutConfig.getTimeoutMetric().getMetricName()).intValue();
        if (meanTimeoutValue <= 0) {
            return initialTimeoutAttributesBuilder.meanTimeout(meanTimeoutValue).build();
        }
        double timeoutBuffer = timeoutConfig.getAllMethodTimeoutBuffer();
        if (currentTimeout < meanTimeoutValue || (double)currentTimeout > (double)meanTimeoutValue * timeoutBuffer) {
            return OptimalTimeoutAttributes.builder().meanTimeout(meanTimeoutValue).timeoutBuffer(timeoutBuffer).optimalTimeout((int)((double)meanTimeoutValue * timeoutBuffer)).build();
        }
        return initialTimeoutAttributesBuilder.meanTimeout(meanTimeoutValue).timeoutBuffer(timeoutBuffer).build();
    }

    private void takeAction(final List<HystrixCommandConfig> hystrixCommandConfigs) {
        this.allowedActions.getActionConfigs().forEach(actionConfig -> actionConfig.accept(new ActionTypeVisitor<Void>(){

            @Override
            public Void visitUpdateHystrixConfig(UpdateHystrixConfig updateHystrixConfig) {
                HystrixConfigUpdater.this.hystrixConfig.setCommands(hystrixCommandConfigs);
                HystrixConfigurationFactory.init((HystrixConfig)HystrixConfigUpdater.this.hystrixConfig);
                log.debug("Updated Hystrix config with command cache : {}, pool cache: {}", (Object)HystrixConfigurationFactory.getCommandCache(), (Object)HystrixConfigurationFactory.getPoolCache());
                return null;
            }

            @Override
            public Void visitSendEmailAlert(EmailConfig emailConfig) {
                String jsonDiff = HystrixConfigUpdater.this.diffHelper.getObjectDiff(HystrixConfigUpdater.this.initialHystrixConfig, HystrixConfigUpdater.this.hystrixConfig);
                if (!Strings.isNullOrEmpty((String)jsonDiff)) {
                    log.info("Sending Email Alert for Config Update");
                    HystrixConfigUpdater.this.emailClient.sendEmail(EmailUtil.emailAddresses(emailConfig.getReceivers()), "Hystrix Config Updated", jsonDiff);
                }
                return null;
            }
        }));
    }

    public HystrixConfig getHystrixConfig() {
        return this.hystrixConfig;
    }

    public HystrixConfig getInitialHystrixConfig() {
        return this.initialHystrixConfig;
    }

    public OptimizerConfig getOptimizerConfig() {
        return this.optimizerConfig;
    }

    public OptimizerMetricsCache getOptimizerMetricsCache() {
        return this.optimizerMetricsCache;
    }

    public Map<String, HystrixCommandConfig> getInitialHystrixCommandConfigMap() {
        return this.initialHystrixCommandConfigMap;
    }

    public Actions getAllowedActions() {
        return this.allowedActions;
    }

    public EmailClient getEmailClient() {
        return this.emailClient;
    }

    public DiffHelper<HystrixConfig> getDiffHelper() {
        return this.diffHelper;
    }

    public void setHystrixConfig(HystrixConfig hystrixConfig) {
        this.hystrixConfig = hystrixConfig;
    }

    public void setInitialHystrixConfig(HystrixConfig initialHystrixConfig) {
        this.initialHystrixConfig = initialHystrixConfig;
    }

    public void setOptimizerConfig(OptimizerConfig optimizerConfig) {
        this.optimizerConfig = optimizerConfig;
    }

    public void setOptimizerMetricsCache(OptimizerMetricsCache optimizerMetricsCache) {
        this.optimizerMetricsCache = optimizerMetricsCache;
    }

    public void setInitialHystrixCommandConfigMap(Map<String, HystrixCommandConfig> initialHystrixCommandConfigMap) {
        this.initialHystrixCommandConfigMap = initialHystrixCommandConfigMap;
    }

    public void setAllowedActions(Actions allowedActions) {
        this.allowedActions = allowedActions;
    }

    public void setEmailClient(EmailClient emailClient) {
        this.emailClient = emailClient;
    }

    public void setDiffHelper(DiffHelper<HystrixConfig> diffHelper) {
        this.diffHelper = diffHelper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HystrixConfigUpdater)) {
            return false;
        }
        HystrixConfigUpdater other = (HystrixConfigUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HystrixConfig this$hystrixConfig = this.getHystrixConfig();
        HystrixConfig other$hystrixConfig = other.getHystrixConfig();
        if (this$hystrixConfig == null ? other$hystrixConfig != null : !this$hystrixConfig.equals(other$hystrixConfig)) {
            return false;
        }
        HystrixConfig this$initialHystrixConfig = this.getInitialHystrixConfig();
        HystrixConfig other$initialHystrixConfig = other.getInitialHystrixConfig();
        if (this$initialHystrixConfig == null ? other$initialHystrixConfig != null : !this$initialHystrixConfig.equals(other$initialHystrixConfig)) {
            return false;
        }
        OptimizerConfig this$optimizerConfig = this.getOptimizerConfig();
        OptimizerConfig other$optimizerConfig = other.getOptimizerConfig();
        if (this$optimizerConfig == null ? other$optimizerConfig != null : !((Object)this$optimizerConfig).equals(other$optimizerConfig)) {
            return false;
        }
        OptimizerMetricsCache this$optimizerMetricsCache = this.getOptimizerMetricsCache();
        OptimizerMetricsCache other$optimizerMetricsCache = other.getOptimizerMetricsCache();
        if (this$optimizerMetricsCache == null ? other$optimizerMetricsCache != null : !((Object)this$optimizerMetricsCache).equals(other$optimizerMetricsCache)) {
            return false;
        }
        Map<String, HystrixCommandConfig> this$initialHystrixCommandConfigMap = this.getInitialHystrixCommandConfigMap();
        Map<String, HystrixCommandConfig> other$initialHystrixCommandConfigMap = other.getInitialHystrixCommandConfigMap();
        if (this$initialHystrixCommandConfigMap == null ? other$initialHystrixCommandConfigMap != null : !((Object)this$initialHystrixCommandConfigMap).equals(other$initialHystrixCommandConfigMap)) {
            return false;
        }
        Actions this$allowedActions = this.getAllowedActions();
        Actions other$allowedActions = other.getAllowedActions();
        if (this$allowedActions == null ? other$allowedActions != null : !((Object)this$allowedActions).equals(other$allowedActions)) {
            return false;
        }
        EmailClient this$emailClient = this.getEmailClient();
        EmailClient other$emailClient = other.getEmailClient();
        if (this$emailClient == null ? other$emailClient != null : !this$emailClient.equals(other$emailClient)) {
            return false;
        }
        DiffHelper<HystrixConfig> this$diffHelper = this.getDiffHelper();
        DiffHelper<HystrixConfig> other$diffHelper = other.getDiffHelper();
        return !(this$diffHelper == null ? other$diffHelper != null : !this$diffHelper.equals(other$diffHelper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HystrixConfigUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HystrixConfig $hystrixConfig = this.getHystrixConfig();
        result = result * 59 + ($hystrixConfig == null ? 43 : $hystrixConfig.hashCode());
        HystrixConfig $initialHystrixConfig = this.getInitialHystrixConfig();
        result = result * 59 + ($initialHystrixConfig == null ? 43 : $initialHystrixConfig.hashCode());
        OptimizerConfig $optimizerConfig = this.getOptimizerConfig();
        result = result * 59 + ($optimizerConfig == null ? 43 : ((Object)$optimizerConfig).hashCode());
        OptimizerMetricsCache $optimizerMetricsCache = this.getOptimizerMetricsCache();
        result = result * 59 + ($optimizerMetricsCache == null ? 43 : ((Object)$optimizerMetricsCache).hashCode());
        Map<String, HystrixCommandConfig> $initialHystrixCommandConfigMap = this.getInitialHystrixCommandConfigMap();
        result = result * 59 + ($initialHystrixCommandConfigMap == null ? 43 : ((Object)$initialHystrixCommandConfigMap).hashCode());
        Actions $allowedActions = this.getAllowedActions();
        result = result * 59 + ($allowedActions == null ? 43 : ((Object)$allowedActions).hashCode());
        EmailClient $emailClient = this.getEmailClient();
        result = result * 59 + ($emailClient == null ? 43 : $emailClient.hashCode());
        DiffHelper<HystrixConfig> $diffHelper = this.getDiffHelper();
        result = result * 59 + ($diffHelper == null ? 43 : $diffHelper.hashCode());
        return result;
    }

    public String toString() {
        return "HystrixConfigUpdater(hystrixConfig=" + this.getHystrixConfig() + ", initialHystrixConfig=" + this.getInitialHystrixConfig() + ", optimizerConfig=" + this.getOptimizerConfig() + ", optimizerMetricsCache=" + this.getOptimizerMetricsCache() + ", initialHystrixCommandConfigMap=" + this.getInitialHystrixCommandConfigMap() + ", allowedActions=" + this.getAllowedActions() + ", emailClient=" + this.getEmailClient() + ", diffHelper=" + this.getDiffHelper() + ")";
    }

    public HystrixConfigUpdater() {
    }

    public HystrixConfigUpdater(HystrixConfig hystrixConfig, HystrixConfig initialHystrixConfig, OptimizerConfig optimizerConfig, OptimizerMetricsCache optimizerMetricsCache, Map<String, HystrixCommandConfig> initialHystrixCommandConfigMap, Actions allowedActions, EmailClient emailClient, DiffHelper<HystrixConfig> diffHelper) {
        this.hystrixConfig = hystrixConfig;
        this.initialHystrixConfig = initialHystrixConfig;
        this.optimizerConfig = optimizerConfig;
        this.optimizerMetricsCache = optimizerMetricsCache;
        this.initialHystrixCommandConfigMap = initialHystrixCommandConfigMap;
        this.allowedActions = allowedActions;
        this.emailClient = emailClient;
        this.diffHelper = diffHelper;
    }
}

