/*
 * Decompiled with CFR 0.152.
 */
package io.phonepe.hystrixoptimizer;

import com.codahale.metrics.MetricRegistry;
import com.hystrix.configurator.config.HystrixConfig;
import com.hystrix.configurator.core.HystrixConfigurationFactory;
import com.netflix.hystrix.contrib.codahalemetricspublisher.HystrixCodaHaleMetricsPublisher;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.phonepe.hystrixoptimizer.config.OptimizerConfig;
import io.phonepe.hystrixoptimizer.config.OptimizerConfigUpdaterConfig;
import io.phonepe.hystrixoptimizer.config.OptimizerMetricsCollectorConfig;
import io.phonepe.hystrixoptimizer.core.HystrixConfigUpdater;
import io.phonepe.hystrixoptimizer.core.OptimizerMetricsCache;
import io.phonepe.hystrixoptimizer.core.OptimizerMetricsCollector;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HystrixOptimizerBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(HystrixOptimizerBundle.class);

    public abstract HystrixConfig getHystrixConfig(T var1);

    public abstract OptimizerConfig getOptimizerConfig(T var1);

    public void initialize(Bootstrap<?> bootstrap) {
        HystrixPlugins.reset();
    }

    public void run(T configuration, Environment environment) {
        HystrixCodaHaleMetricsPublisher metricsPublisher = new HystrixCodaHaleMetricsPublisher(environment.metrics());
        MetricRegistry metrics = environment.metrics();
        ScheduledExecutorService metricsBuilderExecutorService = environment.lifecycle().scheduledExecutorService("optimizer-metrics-builder").build();
        ScheduledExecutorService configUpdaterExecutorService = environment.lifecycle().scheduledExecutorService("hystrix-config-updater").build();
        HystrixPlugins.getInstance().registerMetricsPublisher((HystrixMetricsPublisher)metricsPublisher);
        HystrixConfig hystrixConfig = this.getHystrixConfig(configuration);
        HystrixConfigurationFactory.init((HystrixConfig)hystrixConfig);
        this.setupOptimizer(this.getOptimizerConfig(configuration), hystrixConfig, metrics, metricsBuilderExecutorService, configUpdaterExecutorService);
    }

    private void setupOptimizer(OptimizerConfig optimizerConfig, HystrixConfig hystrixConfig, MetricRegistry metrics, ScheduledExecutorService metricsBuilderExecutorService, ScheduledExecutorService configUpdaterExecutorService) {
        if (optimizerConfig != null && optimizerConfig.isEnabled()) {
            log.info("Optimizer config enabled");
            OptimizerMetricsCollectorConfig optimizerMetricsCollectorConfig = optimizerConfig.getMetricsCollectorConfig();
            OptimizerMetricsCache optimizerMetricsCache = OptimizerMetricsCache.builder().optimizerMetricsCollectorConfig(optimizerMetricsCollectorConfig).build();
            OptimizerMetricsCollector optimizerMetricsCollector = OptimizerMetricsCollector.builder().metrics(metrics).optimizerMetricsCache(optimizerMetricsCache).optimizerConfig(optimizerConfig).build();
            metricsBuilderExecutorService.scheduleAtFixedRate(optimizerMetricsCollector, optimizerConfig.getInitialDelay(), optimizerMetricsCollectorConfig.getRepeatAfter(), optimizerMetricsCollectorConfig.getTimeUnit());
            HystrixConfigUpdater hystrixConfigUpdater = HystrixConfigUpdater.builder().optimizerConfig(optimizerConfig).optimizerMetricsCache(optimizerMetricsCache).hystrixConfig(hystrixConfig).build();
            OptimizerConfigUpdaterConfig configUpdaterConfig = optimizerConfig.getConfigUpdaterConfig();
            configUpdaterExecutorService.scheduleAtFixedRate(hystrixConfigUpdater, optimizerConfig.getInitialDelay(), configUpdaterConfig.getRepeatAfter(), configUpdaterConfig.getTimeUnit());
        }
    }
}

