/*
 * Decompiled with CFR 0.152.
 */
package io.pedestal.servlet;

import clojure.lang.IFn;
import io.pedestal.servlet.ConnectorBridge;
import io.pedestal.servlet.Util;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class ConnectorServlet
implements Servlet {
    private ServletConfig config;
    private ConnectorBridge bridge;

    public void init(ServletConfig servletConfig) throws ServletException {
        this.config = servletConfig;
        IFn iFn = Util.getVar(servletConfig, "io.pedestal.connector.bridge-fn", true);
        this.bridge = (ConnectorBridge)iFn.invoke((Object)this);
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) {
        this.bridge.service((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
    }

    public String getServletInfo() {
        return "Pedestal Connector";
    }

    public void destroy() {
        if (this.bridge != null) {
            this.bridge.destroy();
            this.bridge = null;
        }
    }
}

