/*
 * Decompiled with CFR 0.152.
 */
package io.pedestal.servlet.mock;

import io.pedestal.servlet.mock.MockAsyncContext;
import io.pedestal.servlet.mock.MockHttpServletRequest;
import io.pedestal.servlet.mock.MockHttpServletResponse;
import io.pedestal.servlet.mock.MockServletInputStream;
import io.pedestal.servlet.mock.MockServletOutputStream;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MockState {
    final String url;
    final String method;
    final String scheme;
    final String host;
    final String path;
    final String queryString;
    final int port;
    final Map<String, String> requestHeaders;
    public final Map<String, String> setResponseHeaders = new HashMap<String, String>();
    public final Map<String, List<String>> addedResponseHeaders = new HashMap<String, List<String>>();
    final ServletInputStream requestStream;
    final ServletOutputStream servletOutputStream;
    public final ByteArrayOutputStream responseStream = new ByteArrayOutputStream(1000);
    public final HttpServletRequest request;
    public final HttpServletResponse response;
    final MockAsyncContext asyncContext;
    public boolean asyncStarted;
    public int responseStatus = 0;
    public long responseContentLength;
    final CountDownLatch completed = new CountDownLatch(1);
    boolean responseCommitted = false;

    public MockState(String string, String string2, String string3, String string4, int n, String string5, String string6, Map<String, String> map, InputStream inputStream) {
        this.url = string;
        this.method = string2;
        this.scheme = string3;
        this.host = string4;
        this.port = n;
        this.path = string5;
        this.queryString = string6;
        this.requestHeaders = map;
        this.request = new MockHttpServletRequest(this);
        this.response = new MockHttpServletResponse(this);
        this.asyncContext = new MockAsyncContext(this);
        this.requestStream = new MockServletInputStream(inputStream);
        this.servletOutputStream = new MockServletOutputStream(this, this.responseStream);
    }

    void complete() {
        this.completed.countDown();
    }

    public boolean waitForCompletion(long l) {
        try {
            return this.completed.await(l, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

