/*
 * Decompiled with CFR 0.152.
 */
package io.pedestal.servlet.mock;

import io.pedestal.servlet.mock.MockState;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class MockHttpServletRequest
implements HttpServletRequest {
    private final MockState state;

    MockHttpServletRequest(MockState mockState) {
        this.state = mockState;
    }

    public String getAuthType() {
        return "";
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String string) {
        return 0L;
    }

    public String getHeader(String string) {
        return this.state.requestHeaders.get(string);
    }

    public Enumeration<String> getHeaders(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(Collections.singletonList(string2));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.state.requestHeaders.keySet());
    }

    public int getIntHeader(String string) {
        return 0;
    }

    public String getMethod() {
        return this.state.method;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return "";
    }

    public String getContextPath() {
        return "";
    }

    public String getQueryString() {
        return this.state.queryString;
    }

    public String getRemoteUser() {
        return "";
    }

    public boolean isUserInRole(String string) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return "";
    }

    public String getRequestURI() {
        return "/" + this.state.path;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getServletPath() {
        return this.getRequestURI();
    }

    public HttpSession getSession(boolean bl) {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public String changeSessionId() {
        return "";
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return false;
    }

    public void login(String string, String string2) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return List.of();
    }

    public Part getPart(String string) throws IOException, ServletException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> clazz) throws IOException, ServletException {
        return null;
    }

    public Object getAttribute(String string) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return null;
    }

    public String getCharacterEncoding() {
        return "UTF-8";
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
    }

    public int getContentLength() {
        String string = this.state.requestHeaders.get("Content-Length");
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public long getContentLengthLong() {
        String string = this.state.requestHeaders.get("Content-Length");
        if (string == null) {
            return 0L;
        }
        return Long.parseLong(string);
    }

    public String getContentType() {
        return this.state.requestHeaders.get("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.state.requestStream;
    }

    public String getParameter(String string) {
        return "";
    }

    public Enumeration<String> getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String string) {
        return new String[0];
    }

    public Map<String, String[]> getParameterMap() {
        return Map.of();
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getScheme() {
        return this.state.scheme;
    }

    public String getServerName() {
        return this.state.host;
    }

    public int getServerPort() {
        return 0;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return "127.0.0.1";
    }

    public String getRemoteHost() {
        return "";
    }

    public void setAttribute(String string, Object object) {
    }

    public void removeAttribute(String string) {
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration<Locale> getLocales() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return "";
    }

    public String getLocalAddr() {
        return "";
    }

    public int getLocalPort() {
        return 0;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        this.state.asyncStarted = true;
        return this.state.asyncContext;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return this.state.asyncStarted;
    }

    public boolean isAsyncSupported() {
        return true;
    }

    public AsyncContext getAsyncContext() {
        return this.isAsyncStarted() ? this.state.asyncContext : null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public String getRequestId() {
        return "";
    }

    public String getProtocolRequestId() {
        return "";
    }

    public ServletConnection getServletConnection() {
        return null;
    }
}

