/*
 * Decompiled with CFR 0.152.
 */
package io.pedestal.websocket;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.Symbol;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;

public class FnEndpoint
extends Endpoint {
    public static final String USER_ATTRIBUTE_KEY = "io.pedestal.http.jetty.websockets.FnEndpoint";
    private static final Keyword onOpenKw = FnEndpoint.kw("on-open");
    private static final Keyword onCloseKw = FnEndpoint.kw("on-close");
    private static final Keyword onErrorKw = FnEndpoint.kw("on-error");
    private IFn callback;

    private static Keyword kw(String string) {
        return Keyword.intern((Symbol)Symbol.intern(null, (String)string));
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        this.callback = (IFn)endpointConfig.getUserProperties().get(USER_ATTRIBUTE_KEY);
        this.callback.invoke((Object)onOpenKw, (Object)session, (Object)endpointConfig);
    }

    public void onClose(Session session, CloseReason closeReason) {
        if (this.callback != null) {
            this.callback.invoke((Object)onCloseKw, (Object)session, (Object)closeReason);
        }
    }

    public void onError(Session session, Throwable throwable) {
        if (this.callback != null) {
            this.callback.invoke((Object)onErrorKw, (Object)session, (Object)throwable);
        }
    }
}

