/*
 * Decompiled with CFR 0.152.
 */
package io.partx.example;

import com.codahale.metrics.Counter;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import io.partx.core.Event;
import io.partx.core.EventListener;
import io.partx.core.Metadata;
import io.partx.core.Particle;
import io.partx.core.Partx;
import io.partx.core.annotation.Listener;
import io.partx.core.annotation.Metric;
import io.partx.core.annotation.Property;
import io.partx.core.annotation.Route;
import io.partx.core.annotation.RouteList;
import io.partx.core.vertx.HttpService;
import io.partx.core.vertx.Response;
import io.partx.core.vertx.VertxBundle;
import io.partx.core.vertx.VertxWebBundle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.ErrorHandler;
import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexExample {
    private static final Logger log = LoggerFactory.getLogger(ComplexExample.class);

    public static void main(String[] args) {
        new ComplexExample().run();
    }

    private void run() {
        Partx.define((Metadata)Metadata.builder().name("sample-app-1").version("0.1").build()).use(new Module[]{new VertxBundle().configFile("partx-conf-simple.yaml").httpServerOptions(new HttpServerOptions().setSsl(false).setCompressionSupported(true)), new VertxWebBundle()}).set("app.env", (Object)"test").set("http.port", (Object)8080).run(new Class[]{PartxApp.class, HttpService.class, TestEventListener.class});
    }

    public static class Pojo {
        private String name;
        private String session;
        private double value;

        public static PojoBuilder builder() {
            return new PojoBuilder();
        }

        @ConstructorProperties(value={"name", "session", "value"})
        public Pojo(String name, String session, double value) {
            this.name = name;
            this.session = session;
            this.value = value;
        }

        public Pojo() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSession() {
            return this.session;
        }

        public void setSession(String session) {
            this.session = session;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public static class PojoBuilder {
            private String name;
            private String session;
            private double value;

            PojoBuilder() {
            }

            public PojoBuilder name(String name) {
                this.name = name;
                return this;
            }

            public PojoBuilder session(String session) {
                this.session = session;
                return this;
            }

            public PojoBuilder value(double value) {
                this.value = value;
                return this;
            }

            public Pojo build() {
                return new Pojo(this.name, this.session, this.value);
            }

            public String toString() {
                return "ComplexExample.Pojo.PojoBuilder(name=" + this.name + ", session=" + this.session + ", value=" + this.value + ")";
            }
        }
    }

    @Singleton
    private static class MyServiceImpl
    implements MyService {
        private MyServiceImpl() {
        }

        @Override
        public String echo() {
            return "Echo";
        }

        @Override
        public void save(Pojo pojo, Handler<AsyncResult<Pojo>> handler) {
            Future.future(promise -> promise.complete((Object)pojo)).setHandler(handler);
        }

        public void update(Pojo pojo, Handler<AsyncResult<Pojo>> handler) {
            Future.future(promise -> promise.complete((Object)pojo)).setHandler(handler);
        }

        public void onUpdate(Pojo pojo, Handler<AsyncResult<Pojo>> handler) {
            Future.future(promise -> promise.complete((Object)pojo)).setHandler(handler);
        }
    }

    @ImplementedBy(value=MyServiceImpl.class)
    private static interface MyService {
        public String echo();

        public void save(Pojo var1, Handler<AsyncResult<Pojo>> var2);
    }

    @Listener
    private static class TestEventListener
    implements EventListener {
        private TestEventListener() {
        }

        public void onEvent(Event event) {
            log.info("Received {}", (Object)event);
        }
    }

    @RouteList(value={@Route(order=-2147483648, method={HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH}, handler={BodyHandler.class}), @Route(order=0x7FFFFFFF, handler={ErrorHandler.class})})
    public static class PartxApp {
        private static final Logger log = LoggerFactory.getLogger(PartxApp.class);
        private static AtomicInteger seq = new AtomicInteger();
        private int id;
        @Property(name="app.env", env="APP_ENV", defaultValue="development")
        private String env;
        @Property(name="http.port", sys="http.port", defaultValue="80")
        private int port;
        @Property(name="http.ip", sys="http.ip", defaultValue="localhost")
        private String ip;
        @Property(name="http.ssl", sys="http.ssl", defaultValue="true")
        private boolean ssl;
        @Metric(value="request_counter")
        private Counter counter = new Counter();
        @Metric(value="request_atomic_counter")
        private AtomicDouble atomicCounter = new AtomicDouble();
        @Metric(value="request_int_counter")
        private int intCounter;
        @Metric(value="status_destroyed")
        private boolean destroyed;
        @Metric(value="status_started")
        private boolean started;
        @Metric(value="status_initialized")
        private boolean initialized;
        @Inject
        private MyService myService;
        @Inject
        private Particle particle;
        @Inject
        private Vertx vertx;

        public PartxApp() {
            this.id = seq.incrementAndGet();
        }

        @Route(value="/")
        public String home() {
            return "Hi";
        }

        @Route(value="/pojo/:name", method={HttpMethod.GET}, blocking=true, ordered=false)
        public Response getPojo(RoutingContext routing) {
            return Response.ok((Object)Pojo.builder().name("PojoName").value(0.98).build());
        }

        @Route(value="/pojo", method={HttpMethod.POST}, produces={"application/json"})
        public void createPojo(RoutingContext routingContext) {
            this.myService.save(Pojo.builder().build(), (Handler<AsyncResult<Pojo>>)((Handler)event -> {}));
        }

        @Route(value="/echo", method={HttpMethod.GET}, produces={"text/plain"})
        public Response echo() {
            return Response.ok((String)this.myService.echo());
        }

        @Listener(value={Event.Type.Shutdown})
        public void destroy() {
            log.info("Stopping ...");
            this.destroyed = true;
        }

        @Listener(value={Event.Type.Initialize})
        public void init() {
            log.info("Starting now");
            this.initialized = true;
        }

        @Listener(value={Event.Type.Start})
        public void start() {
            log.info("Starting now");
            this.started = true;
        }

        public int getId() {
            return this.id;
        }

        public String getEnv() {
            return this.env;
        }

        public int getPort() {
            return this.port;
        }

        public String getIp() {
            return this.ip;
        }

        public boolean isSsl() {
            return this.ssl;
        }

        public Counter getCounter() {
            return this.counter;
        }

        public AtomicDouble getAtomicCounter() {
            return this.atomicCounter;
        }

        public int getIntCounter() {
            return this.intCounter;
        }

        public boolean isDestroyed() {
            return this.destroyed;
        }

        public boolean isStarted() {
            return this.started;
        }

        public boolean isInitialized() {
            return this.initialized;
        }
    }
}

