/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.vertx;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.channel.EventLoopGroup;
import io.partx.core.Config;
import io.partx.core.Event;
import io.partx.core.Particle;
import io.partx.core.annotation.Listener;
import io.partx.core.internal.Workers;
import io.partx.core.metric.DropwizardMetricExports;
import io.partx.core.metric.Metrics;
import io.partx.core.metric.MetricsImpl;
import io.partx.core.utils.Async;
import io.partx.core.vertx.ConfigService;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.shareddata.SharedData;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import io.vertx.ext.dropwizard.MetricsService;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxBundle
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(VertxBundle.class);
    private VertxOptions vertxOptions = new VertxOptions().setEventLoopPoolSize(1).setMaxEventLoopExecuteTime(TimeUnit.SECONDS.toNanos(20L)).setBlockedThreadCheckInterval(TimeUnit.SECONDS.toMillis(30L)).setWarningExceptionTime(TimeUnit.SECONDS.toNanos(30L)).setAddressResolverOptions(new AddressResolverOptions().setNdots(3).setCacheMinTimeToLive(300).setCacheNegativeTimeToLive(60));
    private DropwizardMetricsOptions metricsOptions = new DropwizardMetricsOptions().setRegistryName("vertx").setBaseName("partx").setJmxEnabled(true).setJmxDomain("io.partx");
    private HttpClientOptions httpClientOptions = new HttpClientOptions().setKeepAlive(false).setConnectTimeout(5000).setMaxChunkSize(0xA00000).setSsl(false).setTrustAll(true).setIdleTimeout(50).setVerifyHost(false).setTryUseCompression(true);
    private ConfigRetrieverOptions configRetriever = new ConfigRetrieverOptions().setIncludeDefaultStores(false);
    private HttpServerOptions httpServerOptions = new HttpServerOptions().setSsl(false).setCompressionSupported(true);
    private ConfigService configUpdater;
    @Inject
    private Particle particle;
    @Inject
    private Config config;

    public VertxBundle configFrom(String type, String format, String path) {
        if (this.configRetriever == null) {
            this.configRetriever = new ConfigRetrieverOptions().setIncludeDefaultStores(false);
        }
        this.configRetriever.addStore(new ConfigStoreOptions().setType(type).setFormat(format).setConfig(new JsonObject().put("path", path)));
        return this;
    }

    public VertxBundle configFile(String path) {
        String format = FilenameUtils.getExtension((String)path);
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)format) ? 1 : 0) != 0, (Object)("Format " + format + " is unable to identify from path: " + path));
        return this.configFrom("file", format, path);
    }

    protected void configure() {
        if (this.vertxOptions.getEventBusOptions().isClustered()) {
            this.configure((Vertx)Async.blocking(future -> Vertx.clusteredVertx((VertxOptions)this.vertxOptions, event -> {
                if (event.succeeded()) {
                    future.complete(event.result());
                } else {
                    future.completeExceptionally(event.cause());
                }
            })));
        } else {
            this.configure(Vertx.vertx((VertxOptions)this.vertxOptions));
        }
    }

    protected void configure(final Vertx vertx) {
        if (this.vertxOptions.getMetricsOptions() == null) {
            this.vertxOptions.setMetricsOptions((MetricsOptions)this.metricsOptions);
        } else if (this.vertxOptions.getMetricsOptions() instanceof DropwizardMetricsOptions) {
            this.metricsOptions = (DropwizardMetricsOptions)this.vertxOptions.getMetricsOptions();
        }
        if (this.vertxOptions.getMetricsOptions() != null) {
            MetricRegistry metricRegistry = SharedMetricRegistries.getOrCreate((String)this.metricsOptions.getRegistryName());
            SharedMetricRegistries.setDefault((String)this.metricsOptions.getRegistryName());
            MetricsImpl metricInfoRegistry = new MetricsImpl(metricRegistry);
            this.bind(MetricRegistry.class).toInstance((Object)metricRegistry);
            this.bind(Metrics.class).toInstance((Object)metricInfoRegistry);
            this.bind(MetricsService.class).toProvider(() -> MetricsService.create((Vertx)vertx)).in(Singleton.class);
            CollectorRegistry.defaultRegistry.register((Collector)new DropwizardMetricExports(metricRegistry, metricInfoRegistry));
        }
        vertx.exceptionHandler(this::handleException);
        this.configUpdater = new ConfigService(this.config, vertx, this.configRetriever);
        this.bind(Vertx.class).toInstance((Object)vertx);
        this.bind(EventBus.class).toProvider(() -> ((Vertx)vertx).eventBus());
        this.bind(FileSystem.class).toProvider(() -> ((Vertx)vertx).fileSystem());
        this.bind(SharedData.class).toProvider(() -> ((Vertx)vertx).sharedData());
        this.bind(EventLoopGroup.class).toProvider(() -> ((Vertx)vertx).nettyEventLoopGroup());
        this.bind(HttpServer.class).toProvider(() -> {
            this.httpServerOptions.setSsl(this.httpServerOptions.isSsl() || this.config.get("http.server.ssl", Boolean.class).orElse(false) != false);
            return vertx.createHttpServer(this.httpServerOptions);
        }).in(Singleton.class);
        this.bind(HttpClient.class).toProvider(() -> {
            this.httpClientOptions.setSsl(this.config.get("http.client.ssl", Boolean.class).orElse(false) != false || this.httpClientOptions.isSsl());
            return vertx.createHttpClient(this.httpClientOptions);
        }).in(Singleton.class);
        this.bind(WorkerExecutor.class).toProvider(() -> vertx.createSharedWorkerExecutor(this.config.get("vertx.worker.name", String.class).orElse("WorkExecutor"), this.config.get("vertx.worker.poolSize", Integer.class).orElse(8).intValue())).in(Singleton.class);
        this.bind(Workers.class).toProvider(() -> new Workers(){

            @Override
            public <T> CompletableFuture<T> execute(Callable<T> runnable, boolean blocking) {
                CompletableFuture promise = new CompletableFuture();
                if (blocking) {
                    VertxBundle.this.particle.get(WorkerExecutor.class).executeBlocking(result -> {
                        try {
                            result.complete(runnable.call());
                        }
                        catch (Exception e) {
                            result.fail((Throwable)e);
                        }
                    }, result -> {
                        if (result.succeeded()) {
                            promise.complete(result.result());
                        } else {
                            promise.completeExceptionally(result.cause());
                        }
                    });
                } else {
                    vertx.runOnContext(result -> {
                        try {
                            promise.complete(runnable.call());
                        }
                        catch (Exception e) {
                            promise.completeExceptionally(e);
                        }
                    });
                }
                return promise;
            }
        }).in(Singleton.class);
    }

    private void handleException(Throwable throwable) {
        log.error("Unhandled exception", throwable);
    }

    @Listener(value={Event.Type.Initialize}, order=-2147483648)
    public void init() {
        this.configUpdater.update();
    }

    @Listener(value={Event.Type.Shutdown}, order=-2147483648)
    public void destroy() {
        this.configUpdater.close();
        log.info("Closing vertx");
        this.particle.get(Vertx.class).close(event -> {
            if (event.succeeded()) {
                log.info("Succeeded to close vertx");
            } else {
                log.error("Failed to close vertx", event.cause());
            }
        });
    }

    public VertxOptions vertxOptions() {
        return this.vertxOptions;
    }

    public VertxBundle vertxOptions(VertxOptions vertxOptions) {
        this.vertxOptions = vertxOptions;
        return this;
    }

    public DropwizardMetricsOptions metricsOptions() {
        return this.metricsOptions;
    }

    public VertxBundle metricsOptions(DropwizardMetricsOptions metricsOptions) {
        this.metricsOptions = metricsOptions;
        return this;
    }

    public HttpClientOptions httpClientOptions() {
        return this.httpClientOptions;
    }

    public VertxBundle httpClientOptions(HttpClientOptions httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
        return this;
    }

    public ConfigRetrieverOptions configRetriever() {
        return this.configRetriever;
    }

    public VertxBundle configRetriever(ConfigRetrieverOptions configRetriever) {
        this.configRetriever = configRetriever;
        return this;
    }

    public HttpServerOptions httpServerOptions() {
        return this.httpServerOptions;
    }

    public VertxBundle httpServerOptions(HttpServerOptions httpServerOptions) {
        this.httpServerOptions = httpServerOptions;
        return this;
    }

    static {
        System.setProperty("vertx.logger-delegate-factory-class-name", "io.vertx.core.logging.SLF4JLogDelegateFactory");
    }
}

