/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.metric;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.beans.ConstructorProperties;
import java.util.Map;

public class MetricInfo<T extends Metric> {
    private String name;
    private Map<String, String> tags;
    private T metric;

    public String getDropWizardMetricName() {
        String[] parts = new String[this.tags.size()];
        int index = 0;
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            parts[index] = entry.getKey() + "_" + entry.getValue();
            ++index;
        }
        return MetricRegistry.name((String)this.name, (String[])parts);
    }

    public String getMetricId() {
        return this.getDropWizardMetricName();
    }

    public String getPrometheusMetricName() {
        return this.name.replace(".", "_");
    }

    @ConstructorProperties(value={"name", "tags", "metric"})
    MetricInfo(String name, Map<String, String> tags, T metric) {
        this.name = name;
        this.tags = tags;
        this.metric = metric;
    }

    public static <T extends Metric> MetricInfoBuilder<T> builder() {
        return new MetricInfoBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricInfo)) {
            return false;
        }
        MetricInfo other = (MetricInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        T this$metric = this.getMetric();
        T other$metric = other.getMetric();
        return !(this$metric == null ? other$metric != null : !this$metric.equals(other$metric));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        T $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : $metric.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public T getMetric() {
        return this.metric;
    }

    public static class MetricInfoBuilder<T extends Metric> {
        private String name;
        private Map<String, String> tags;
        private T metric;

        MetricInfoBuilder() {
        }

        public MetricInfoBuilder<T> name(String name) {
            this.name = name;
            return this;
        }

        public MetricInfoBuilder<T> tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public MetricInfoBuilder<T> metric(T metric) {
            this.metric = metric;
            return this;
        }

        public MetricInfo<T> build() {
            return new MetricInfo<T>(this.name, this.tags, this.metric);
        }

        public String toString() {
            return "MetricInfo.MetricInfoBuilder(name=" + this.name + ", tags=" + this.tags + ", metric=" + this.metric + ")";
        }
    }
}

