/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.internal;

import com.codahale.metrics.Metric;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.partx.core.metric.Metrics;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.function.Supplier;

public class MetricHandler {
    private String name;
    private Supplier<? extends Metric> getter;
    private Object origin;

    @Inject
    public void register(Injector injector, Metrics metrics) {
        Preconditions.checkNotNull((Object)this.name);
        injector.injectMembers(this.getter);
        Metric metric = this.getter.get();
        Preconditions.checkNotNull((Object)metric, (Object)(this.name + " on " + this.origin + " is not initialized"));
        metrics.metric(metric, this.name, new LinkedHashMap<String, String>());
    }

    public static MetricHandlerBuilder builder() {
        return new MetricHandlerBuilder();
    }

    public MetricHandler() {
    }

    @ConstructorProperties(value={"name", "getter", "origin"})
    public MetricHandler(String name, Supplier<? extends Metric> getter, Object origin) {
        this.name = name;
        this.getter = getter;
        this.origin = origin;
    }

    public String toString() {
        return "MetricHandler(name=" + this.getName() + ", getter=" + this.getGetter() + ", origin=" + this.getOrigin() + ")";
    }

    public String getName() {
        return this.name;
    }

    public Supplier<? extends Metric> getGetter() {
        return this.getter;
    }

    public Object getOrigin() {
        return this.origin;
    }

    public static class MetricHandlerBuilder {
        private String name;
        private Supplier<? extends Metric> getter;
        private Object origin;

        MetricHandlerBuilder() {
        }

        public MetricHandlerBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetricHandlerBuilder getter(Supplier<? extends Metric> getter) {
            this.getter = getter;
            return this;
        }

        public MetricHandlerBuilder origin(Object origin) {
            this.origin = origin;
            return this;
        }

        public MetricHandler build() {
            return new MetricHandler(this.name, this.getter, this.origin);
        }

        public String toString() {
            return "MetricHandler.MetricHandlerBuilder(name=" + this.name + ", getter=" + this.getter + ", origin=" + this.origin + ")";
        }
    }
}

