/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.partx.core.Event;
import io.partx.core.EventListener;
import java.beans.ConstructorProperties;
import java.util.Set;

public class EventHandler {
    private Set<Event.Type> type;
    private Set<Class<?>> expect;
    @JsonIgnore
    private Object instance;
    @JsonIgnore
    private EventListener listener;
    private int order;

    @Inject
    public void init(Injector injector) {
        injector.injectMembers((Object)this.listener);
    }

    public static EventHandlerBuilder builder() {
        return new EventHandlerBuilder();
    }

    public String toString() {
        return "EventHandler(type=" + this.getType() + ", expect=" + this.getExpect() + ", instance=" + this.getInstance() + ", listener=" + this.getListener() + ", order=" + this.getOrder() + ")";
    }

    @ConstructorProperties(value={"type", "expect", "instance", "listener", "order"})
    public EventHandler(Set<Event.Type> type, Set<Class<?>> expect, Object instance, EventListener listener, int order) {
        this.type = type;
        this.expect = expect;
        this.instance = instance;
        this.listener = listener;
        this.order = order;
    }

    public EventHandler() {
    }

    public Set<Event.Type> getType() {
        return this.type;
    }

    public void setType(Set<Event.Type> type) {
        this.type = type;
    }

    public Set<Class<?>> getExpect() {
        return this.expect;
    }

    public void setExpect(Set<Class<?>> expect) {
        this.expect = expect;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    public EventListener getListener() {
        return this.listener;
    }

    public void setListener(EventListener listener) {
        this.listener = listener;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public static class EventHandlerBuilder {
        private Set<Event.Type> type;
        private Set<Class<?>> expect;
        private Object instance;
        private EventListener listener;
        private int order;

        EventHandlerBuilder() {
        }

        public EventHandlerBuilder type(Set<Event.Type> type) {
            this.type = type;
            return this;
        }

        public EventHandlerBuilder expect(Set<Class<?>> expect) {
            this.expect = expect;
            return this;
        }

        public EventHandlerBuilder instance(Object instance) {
            this.instance = instance;
            return this;
        }

        public EventHandlerBuilder listener(EventListener listener) {
            this.listener = listener;
            return this;
        }

        public EventHandlerBuilder order(int order) {
            this.order = order;
            return this;
        }

        public EventHandler build() {
            return new EventHandler(this.type, this.expect, this.instance, this.listener, this.order);
        }

        public String toString() {
            return "EventHandler.EventHandlerBuilder(type=" + this.type + ", expect=" + this.expect + ", instance=" + this.instance + ", listener=" + this.listener + ", order=" + this.order + ")";
        }
    }
}

