/*
 * Decompiled with CFR 0.152.
 */
package com.github.ratelimiter.impl;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.github.ratelimiter.Evaluator;
import com.github.ratelimiter.config.impl.AerospikeLimitConfig;
import com.github.ratelimiter.config.impl.LimitProperty;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AerospikeEvaluator
implements Evaluator {
    private static final Logger log = LoggerFactory.getLogger(AerospikeEvaluator.class);
    private final AerospikeClient aerospikeClient;
    private final AerospikeLimitConfig limitConfig;

    @Override
    public boolean validate(String methodName, String clientKey) {
        int numberOfRequestsAllowed;
        long currentNumberOfRequests;
        Record record;
        block4: {
            if (this.limitConfig == null || this.limitConfig.getClientLimits() == null || !this.limitConfig.getClientLimits().containsKey(clientKey) || !this.limitConfig.getClientLimits().get(clientKey).containsKey(methodName)) {
                return true;
            }
            record = null;
            currentNumberOfRequests = 1L;
            Map<String, Map<String, LimitProperty>> clientConfigs = this.limitConfig.getClientLimits();
            LimitProperty clientMethodConfig = clientConfigs.get(clientKey).get(methodName);
            numberOfRequestsAllowed = clientMethodConfig.getRequestsAllowed();
            int timePeriod = clientMethodConfig.getTimePeriodInMinutes();
            String namespace = this.limitConfig.getNamespace();
            Key key = new Key(namespace, methodName, clientKey);
            WritePolicy writePolicy = new WritePolicy();
            try {
                writePolicy.expiration = timePeriod * 60;
                writePolicy.recordExistsAction = RecordExistsAction.CREATE_ONLY;
                Bin newBin = new Bin("count", 1L);
                this.aerospikeClient.put(writePolicy, key, new Bin[]{newBin});
            }
            catch (AerospikeException e) {
                if (e.getResultCode() != 5) break block4;
                writePolicy.expiration = -2;
                writePolicy.recordExistsAction = RecordExistsAction.UPDATE_ONLY;
                Bin updateBin = new Bin("count", 1L);
                record = this.aerospikeClient.operate(writePolicy, key, new Operation[]{Operation.add((Bin)updateBin), Operation.get()});
                currentNumberOfRequests = record.getLong("count");
            }
        }
        if (record != null) {
            return currentNumberOfRequests <= (long)numberOfRequestsAllowed;
        }
        return true;
    }

    public AerospikeEvaluator(AerospikeClient aerospikeClient, AerospikeLimitConfig limitConfig) {
        this.aerospikeClient = aerospikeClient;
        this.limitConfig = limitConfig;
    }
}

