/*
 * Decompiled with CFR 0.152.
 */
package com.github.ratelimiter.filters;

import com.github.ratelimiter.Evaluator;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RateLimiterFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(RateLimiterFilter.class);
    private final ResourceInfo resourceInfo;
    private final Evaluator evaluator;

    public void filter(ContainerRequestContext containerRequestContext) {
        try {
            String clientKey;
            boolean inLimit;
            String methodName = this.resourceInfo.getResourceMethod().getName();
            List clientHeader = (List)containerRequestContext.getHeaders().get((Object)"RATE-LIMITER-ID");
            if (clientHeader != null && !clientHeader.isEmpty() && !(inLimit = this.evaluator.validate(methodName, clientKey = (String)clientHeader.get(0)))) {
                log.info("Request blocked by Rate-Limiter. Url({}), Method ({})", (Object)containerRequestContext.getUriInfo().getAbsolutePath(), (Object)methodName);
                containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build());
            }
        }
        catch (Exception e) {
            log.error("Failed to evaluate rate limiting", (Throwable)e);
        }
    }

    public RateLimiterFilter(ResourceInfo resourceInfo, Evaluator evaluator) {
        this.resourceInfo = resourceInfo;
        this.evaluator = evaluator;
    }
}

