(ns hildebrand.scratch
  (:require [hildebrand.test-util :as test-util]
            [clojure.core.async :as async :refer [go <!]]
            [hildebrand.streams :as streams]
            [hildebrand.streams.page :as streams.page :refer [get-records!]]
            [hildebrand :as h])
  (:import [java.util ArrayDeque]))

(def creds
  (assoc test-util/creds
         :endpoint "http://localhost:8000"))

(h/delete-table!! creds test-util/table)

(h/create-table!!
 creds
 (assoc test-util/create-table-default
        :stream-specification
        {:stream-enabled true
         :stream-view-type :new-and-old-images}))

(defn write! []
  (async/go-loop [i 0]
    (<! (h/put-item! creds test-util/table {:name "Test item" :count i}))
    (<! (h/update-item!
         creds test-util/table {:name "Test item"} {:count [:inc 1]}))
    (<! (h/delete-item! creds test-util/table {:name "Test item"}))
    (<! (async/timeout 1000))
    (recur (inc i))))

(defn read! []
  (go
    (let [stream-id (<! (streams/latest-stream-id! creds test-util/table))
          shard-id  (-> (streams/describe-stream! creds stream-id)
                        <! :shards last :shard-id)
          stream (get-records!
                  creds stream-id shard-id :latest {:limit 100})]
      (loop []
          (when-let [x (<! stream)]
            (println x)
            (recur))))))

;; (h/put-item!! creds test-util/table {:name "Hello"})
;; (h/put-item!! creds test-util/table {:name "Hello" :jar "OK"})
;; (h/delete-item!! creds test-util/table {:name "Hello"})

;; (def stream-id (streams/latest-stream-id!! creds test-util/table))


;; (def iterator (streams/get-shard-iterator!! creds stream-id shard-id :trim-horizon))
;; (streams/get-records!! creds iterator)


