(ns hildebrand.blog
  (:require [hildebrand :as hildebrand]
            [clojure.core.async :as async]))

(def creds
  {:access-key (get (System/getenv) "AWS_ACCESS_KEY")
   :secret-key (get (System/getenv) "AWS_SECRET_KEY")})

(defn blog []
  (hildebrand/create-table!!
   creds
   {:table :curries
    :throughput {:read 1 :write 1}
    :attrs {:name :string :region :string :spiciness :number}
    :keys  [:name]
    :indexes {:global
              [{:name :curries-by-region-spiciness
                :keys [:region :spiciness]
                :project [:all]
                :throughput {:read 1 :write 1}}]}})

  (async/reduce
   (fn [acc {:keys [allergens]}]
     (into acc allergens))
   result)

  (hildebrand/query!!
   creds
   :curries
   {:name [:= "Jalfrezi"]}
   {:paths [[:x :y :z]]
    :filter [:< 1 2]})


  (dynamo/put-item!!
   creds
   :curries
   {:name "Jalfrezi"
    :region "Pakistan"
    :spiciness 4
    :allergens #{"clove" "cinnamon"}
    :contents {"bell pepper" 1 "onion" 2 "tomato" 3 "chili" 2}})

  (hildebrand.page/query!
   creds
   :curries {:region [:= "Pakistan"] :spiciness [:< 5]}
   {:filter [:and [:exists [:ingredients :onion]]
             [:not [:contains [:allergens] "cinnamon"]]]
    :index :curries-by-region-spiciness
    :limit 10})

  (hildebrand/update-item!!
   creds
   :curries
   {:name "Jalfrezi"}
   {:ingredients {:onion [:inc 4]
                  :chili [:dec 1]
                  :tomato [:remove]}
    :allergens   [:concat #{"mustard" "nuts"}]
    :delicious   [:init true]}
   {:when [:and [:<
                 [:ingredients :onion]
                 [:ingredients :tomato]]
           [:contains [:allergens] "clove"]]
    :return :all-new})

  (dynamo/put-item!
   creds
   :characters
   {:name "Gulliver"
    :book "Gulliver's Travels"
    :hobbies #{"running" "walking" "shooting"}
    :friends []}))
