/*
 * Decompiled with CFR 0.152.
 */
package io.kosong.adk.tools;

import clojure.java.api.Clojure;
import clojure.lang.ArraySeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.Symbol;
import clojure.lang.Var;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableMap;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.Schema;
import com.google.genai.types.Type;
import io.reactivex.rxjava3.core.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClojureFunctionTool
extends BaseTool {
    static final Logger logger = LoggerFactory.getLogger(ClojureFunctionTool.class);
    private static final Schema DEFAULT_PARAMETER_SCHEMA = Schema.builder().type("STRING").build();
    private static Map<String, Type> TYPE_MAP = new HashMap<String, Type>();
    private static final IFn DATAFY_FN;
    private static final IFn STRINGIFY_KEYS_FN;
    private static final IFn INTO_SCHEMA_FN;
    private final Var func;
    private final List<Symbol> argList;
    private final FunctionDeclaration functionDeclaration;

    protected ClojureFunctionTool(@NotNull String string, @NotNull String string2, Var var) {
        this(string, string2, var, false);
    }

    protected ClojureFunctionTool(@NotNull String string, @NotNull String string2, Var var, boolean bl) {
        super(string, string2, bl);
        this.func = var;
        this.argList = ClojureFunctionTool.resolveLongestArgList(var);
        this.functionDeclaration = ClojureFunctionTool.initFunctionDeclaration(string, string2, this.argList);
    }

    public static ClojureFunctionTool create(String string, String string2) {
        Var var = (Var)Clojure.var((Object)string, (Object)string2);
        return ClojureFunctionTool.create(var);
    }

    public static ClojureFunctionTool create(Var var) {
        IPersistentMap iPersistentMap = var.meta();
        Symbol symbol = (Symbol)iPersistentMap.valAt((Object)Keyword.intern((String)"name"));
        String string = (String)iPersistentMap.valAt((Object)Keyword.intern((String)"doc"), (Object)"");
        return new ClojureFunctionTool(symbol.getName(), string, var);
    }

    public Single<Map<String, Object>> runAsync(Map<String, Object> map, ToolContext toolContext) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object2 : this.argList) {
            String string = object2.getName();
            if (string.equals("tool-context")) {
                linkedList.add(DATAFY_FN.invoke((Object)toolContext));
                continue;
            }
            linkedList.add(map.getOrDefault(string, null));
        }
        try {
            Object object = this.func.applyTo((ISeq)ArraySeq.create((Object[])linkedList.toArray()));
            if (object == null) {
                return Single.just((Object)ImmutableMap.of());
            }
            if (object instanceof Map) {
                Object object2;
                object2 = (Map)STRINGIFY_KEYS_FN.invoke(object);
                return Single.just((Object)object2);
            }
            return Single.just((Object)ImmutableMap.of((Object)"result", (Object)object));
        }
        catch (Exception exception) {
            logger.error("Error running function tool", (Throwable)exception);
            return Single.just((Object)ImmutableMap.of());
        }
    }

    private static List<Symbol> resolveLongestArgList(Var var) {
        IPersistentMap iPersistentMap = var.meta();
        List list = (List)iPersistentMap.valAt((Object)Keyword.intern((String)"arglists"));
        List list2 = Collections.emptyList();
        for (List list3 : list) {
            if (list3.size() <= list2.size()) continue;
            list2 = list3;
        }
        return list2;
    }

    private static Schema resolveParameterSchema(Symbol symbol) {
        IPersistentMap iPersistentMap = symbol.meta();
        if (iPersistentMap != null) {
            Type type;
            Object object = iPersistentMap.valAt((Object)Keyword.intern((String)"schema"), null);
            if (object != null) {
                return (Schema)INTO_SCHEMA_FN.invoke(object);
            }
            String string = (String)iPersistentMap.valAt((Object)Keyword.intern((String)"tag"), null);
            if (string != null && (type = (Type)TYPE_MAP.getOrDefault(string, null)) != null) {
                return Schema.builder().type(type).build();
            }
        }
        return DEFAULT_PARAMETER_SCHEMA;
    }

    private static FunctionDeclaration initFunctionDeclaration(String string, String string2, List<Symbol> list) {
        LinkedHashMap<String, Schema> linkedHashMap = new LinkedHashMap<String, Schema>();
        for (Symbol symbol : list) {
            if ("tool-context".equals(symbol.getName())) continue;
            String string3 = symbol.getName();
            Schema schema = ClojureFunctionTool.resolveParameterSchema(symbol);
            linkedHashMap.put(string3, schema);
        }
        Schema schema = Schema.builder().properties(linkedHashMap).type(Type.Known.OBJECT).build();
        return FunctionDeclaration.builder().name(string).description(string2).parameters(schema).build();
    }

    public Optional<FunctionDeclaration> declaration() {
        return Optional.ofNullable(this.functionDeclaration);
    }

    static {
        TYPE_MAP.put("String", new Type(Type.Known.STRING));
        TYPE_MAP.put("java.lang.String", new Type(Type.Known.STRING));
        TYPE_MAP.put("boolean", new Type(Type.Known.BOOLEAN));
        TYPE_MAP.put("Boolean", new Type(Type.Known.BOOLEAN));
        TYPE_MAP.put("java.lang.Boolean", new Type(Type.Known.BOOLEAN));
        TYPE_MAP.put("int", new Type(Type.Known.INTEGER));
        TYPE_MAP.put("Integer", new Type(Type.Known.INTEGER));
        TYPE_MAP.put("java.lang.Integer", new Type(Type.Known.INTEGER));
        TYPE_MAP.put("long", new Type(Type.Known.INTEGER));
        TYPE_MAP.put("Long", new Type(Type.Known.INTEGER));
        TYPE_MAP.put("java.lang.Long", new Type(Type.Known.INTEGER));
        TYPE_MAP.put("float", new Type(Type.Known.NUMBER));
        TYPE_MAP.put("Float", new Type(Type.Known.NUMBER));
        TYPE_MAP.put("java.lang.Float", new Type(Type.Known.NUMBER));
        TYPE_MAP.put("double", new Type(Type.Known.NUMBER));
        TYPE_MAP.put("Double", new Type(Type.Known.NUMBER));
        TYPE_MAP.put("java.lang.Double", new Type(Type.Known.NUMBER));
        IFn iFn = Clojure.var((Object)"clojure.core", (Object)"require");
        iFn.invoke((Object)Symbol.intern((String)"io.kosong.adk.protocols"));
        iFn.invoke((Object)Symbol.intern((String)"io.kosong.adk.core"));
        iFn.invoke((Object)Symbol.intern((String)"clojure.datafy"));
        iFn.invoke((Object)Symbol.intern((String)"clojure.walk"));
        DATAFY_FN = Clojure.var((Object)"clojure.datafy", (Object)"datafy");
        STRINGIFY_KEYS_FN = Clojure.var((Object)"clojure.walk", (Object)"stringify-keys");
        INTO_SCHEMA_FN = Clojure.var((Object)"io.kosong.adk.protocols", (Object)"into-schema");
    }
}

