/*
 * Decompiled with CFR 0.152.
 */
package io.kosong.adk.agents;

import clojure.java.api.Clojure;
import clojure.lang.IFn;
import clojure.lang.Symbol;
import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.Event;
import io.reactivex.rxjava3.core.Flowable;
import java.util.LinkedList;
import java.util.List;

public class ClojureAgent
extends BaseAgent {
    private IFn runAsyncFn = null;
    private IFn runLiveFn = null;
    private static final IFn datafyFn;
    private static final IFn intoEventFn;

    protected ClojureAgent(Builder builder) {
        super(builder.name, builder.description, builder.subAgents, builder.beforeAgentCallback, builder.afterAgentCallback);
        this.runAsyncFn = builder.runAsyncFn;
        this.runLiveFn = builder.runLiveFn;
    }

    protected ClojureAgent(String string, String string2, List<? extends BaseAgent> list, List<Callbacks.BeforeAgentCallback> list2, List<Callbacks.AfterAgentCallback> list3, IFn iFn, IFn iFn2) {
        super(string, string2, list, list2, list3);
        this.runAsyncFn = iFn;
        this.runLiveFn = iFn2;
    }

    protected Flowable<Event> runAsyncImpl(InvocationContext invocationContext) {
        if (this.runAsyncFn == null) {
            throw new UnsupportedOperationException("runAsyncImpl is not implemented");
        }
        Object object = datafyFn.invoke((Object)invocationContext);
        Object object2 = this.runAsyncFn.invoke(object);
        if (object2 != null) {
            Event event = (Event)intoEventFn.invoke(object2);
            return Flowable.just((Object)event);
        }
        return Flowable.empty();
    }

    protected Flowable<Event> runLiveImpl(InvocationContext invocationContext) {
        if (this.runLiveFn == null) {
            throw new UnsupportedOperationException("runLiveImpl is not implemented");
        }
        Object object = datafyFn.invoke((Object)invocationContext);
        Object object2 = this.runLiveFn.invoke(object);
        if (object2 != null) {
            Event event = (Event)intoEventFn.invoke(object2);
            return Flowable.just((Object)event);
        }
        return Flowable.empty();
    }

    public static final Builder builder() {
        return new Builder();
    }

    static {
        IFn iFn = Clojure.var((Object)"clojure.core", (Object)"require");
        iFn.invoke((Object)Symbol.intern((String)"io.kosong.adk.protocols"));
        iFn.invoke((Object)Symbol.intern((String)"io.kosong.adk.core"));
        datafyFn = Clojure.var((Object)"clojure.datafy", (Object)"datafy");
        intoEventFn = Clojure.var((Object)"io.kosong.adk.protocols", (Object)"into-event");
    }

    public static final class Builder {
        String name = "";
        String description = "";
        List<? extends BaseAgent> subAgents = new LinkedList<BaseAgent>();
        List<Callbacks.BeforeAgentCallback> beforeAgentCallback = new LinkedList<Callbacks.BeforeAgentCallback>();
        List<Callbacks.AfterAgentCallback> afterAgentCallback = new LinkedList<Callbacks.AfterAgentCallback>();
        IFn runAsyncFn = null;
        IFn runLiveFn = null;

        private Builder() {
        }

        public Builder name(String string) {
            this.name = string;
            return this;
        }

        public Builder description(String string) {
            this.description = string;
            return this;
        }

        public Builder subAgents(List<BaseAgent> list) {
            this.subAgents = list;
            return this;
        }

        public Builder beforeAgentCallback(List<Callbacks.BeforeAgentCallback> list) {
            this.beforeAgentCallback = list;
            return this;
        }

        public Builder afterAgentCallback(List<Callbacks.AfterAgentCallback> list) {
            this.afterAgentCallback = list;
            return this;
        }

        public Builder runAsyncFn(IFn iFn) {
            this.runAsyncFn = iFn;
            return this;
        }

        public Builder runLiveFn(IFn iFn) {
            this.runLiveFn = iFn;
            return this;
        }

        public ClojureAgent build() {
            return new ClojureAgent(this);
        }
    }
}

