/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.utilities;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ResourceUtilities {
    public static String tryCopyResourceToTempFile(String resource, String prefix, String postfix) {
        try {
            return ResourceUtilities.copyResourceToTempFile(resource, prefix, postfix);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String copyResourceToTempFile(String resource, String prefix, String postfix) throws IOExceptionUnchecked {
        InputStream resourceStream = ResourceUtilities.class.getResourceAsStream(resource);
        if (resourceStream == null) {
            throw new IllegalArgumentException("Resource '" + resource + "' not found.");
        }
        try {
            File tempFile = File.createTempFile(prefix, postfix);
            tempFile.deleteOnExit();
            FileOutputStream fileStream = new FileOutputStream(tempFile);
            try {
                IOUtils.copy((InputStream)resourceStream, (OutputStream)fileStream);
                ((OutputStream)fileStream).close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fileStream);
            }
            String string = tempFile.getAbsolutePath();
            return string;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceStream);
        }
    }
}

