/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.impl;

import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.RequestsWindowChecker;

public class RequestsPerSecondChecker
extends RequestsWindowChecker {
    public RequestsPerSecondChecker(int threshold) {
        super(ThrottlingWindowUnit.SECOND, threshold);
    }

    @Override
    public long getCurrentWindow() {
        long mills = System.currentTimeMillis();
        return (mills - mills % 1000L) / 1000L;
    }

    public static RequestsPerSecondCheckerBuilder builder() {
        return new RequestsPerSecondCheckerBuilder();
    }

    public String toString() {
        return "RequestsPerSecondChecker(super=" + super.toString() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestsPerSecondChecker)) {
            return false;
        }
        RequestsPerSecondChecker other = (RequestsPerSecondChecker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestsPerSecondChecker;
    }

    public int hashCode() {
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    public static class RequestsPerSecondCheckerBuilder {
        private int threshold;

        RequestsPerSecondCheckerBuilder() {
        }

        public RequestsPerSecondCheckerBuilder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public RequestsPerSecondChecker build() {
            return new RequestsPerSecondChecker(this.threshold);
        }

        public String toString() {
            return "RequestsPerSecondChecker.RequestsPerSecondCheckerBuilder(threshold=" + this.threshold + ")";
        }
    }
}

