/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling.exception;

import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import java.beans.ConstructorProperties;

public class ThrottlingException
extends RuntimeException {
    private final ThrottlingWindowUnit unit;
    private final long window;
    private final int cardinality;
    private final int threshold;
    private final String message;

    @ConstructorProperties(value={"unit", "window", "cardinality", "threshold", "message"})
    ThrottlingException(ThrottlingWindowUnit unit, long window, int cardinality, int threshold, String message) {
        this.unit = unit;
        this.window = window;
        this.cardinality = cardinality;
        this.threshold = threshold;
        this.message = message;
    }

    public static ThrottlingExceptionBuilder builder() {
        return new ThrottlingExceptionBuilder();
    }

    public ThrottlingWindowUnit getUnit() {
        return this.unit;
    }

    public long getWindow() {
        return this.window;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        return "ThrottlingException(unit=" + (Object)((Object)this.getUnit()) + ", window=" + this.getWindow() + ", cardinality=" + this.getCardinality() + ", threshold=" + this.getThreshold() + ", message=" + this.getMessage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThrottlingException)) {
            return false;
        }
        ThrottlingException other = (ThrottlingException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThrottlingWindowUnit this$unit = this.getUnit();
        ThrottlingWindowUnit other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit)) {
            return false;
        }
        if (this.getWindow() != other.getWindow()) {
            return false;
        }
        if (this.getCardinality() != other.getCardinality()) {
            return false;
        }
        if (this.getThreshold() != other.getThreshold()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThrottlingException;
    }

    public int hashCode() {
        int result = 1;
        result = result * 59 + super.hashCode();
        ThrottlingWindowUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        long $window = this.getWindow();
        result = result * 59 + (int)($window >>> 32 ^ $window);
        result = result * 59 + this.getCardinality();
        result = result * 59 + this.getThreshold();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public static class ThrottlingExceptionBuilder {
        private ThrottlingWindowUnit unit;
        private long window;
        private int cardinality;
        private int threshold;
        private String message;

        ThrottlingExceptionBuilder() {
        }

        public ThrottlingExceptionBuilder unit(ThrottlingWindowUnit unit) {
            this.unit = unit;
            return this;
        }

        public ThrottlingExceptionBuilder window(long window) {
            this.window = window;
            return this;
        }

        public ThrottlingExceptionBuilder cardinality(int cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        public ThrottlingExceptionBuilder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public ThrottlingExceptionBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ThrottlingException build() {
            return new ThrottlingException(this.unit, this.window, this.cardinality, this.threshold, this.message);
        }

        public String toString() {
            return "ThrottlingException.ThrottlingExceptionBuilder(unit=" + (Object)((Object)this.unit) + ", window=" + this.window + ", cardinality=" + this.cardinality + ", threshold=" + this.threshold + ", message=" + this.message + ")";
        }
    }
}

