/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.impl;

import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.RequestsWindowChecker;
import java.util.concurrent.TimeUnit;

public class TimedWindowChecker
extends RequestsWindowChecker {
    private static final long MIN_INACTIVE_WINDOWS_TO_CLEAR = 2L;
    private final ThrottlingWindowUnit unit;
    private final long clearAfterInactiveWindows;
    private long prevWindow;
    private long liveWindow;

    public TimedWindowChecker(String commandName, ThrottlingWindowUnit unit, int threshold, long clearAfterInactiveWindows) {
        super(commandName, threshold);
        this.unit = unit;
        this.liveWindow = this.getWindow();
        this.clearAfterInactiveWindows = Math.max(clearAfterInactiveWindows, 2L);
    }

    private long getWindow() {
        return this.unit.accept(new ThrottlingWindowUnit.ThrottlingWindowVisitor<Long>(){

            @Override
            public Long visitMillisecond() {
                return System.currentTimeMillis();
            }

            @Override
            public Long visitSecond() {
                return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
            }

            @Override
            public Long visitMinute() {
                return TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis());
            }
        });
    }

    @Override
    public boolean isChangeInWindow() {
        long window = this.getWindow();
        if (this.liveWindow != window) {
            this.prevWindow = this.liveWindow;
            this.liveWindow = window;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isOkayToClear() {
        return this.liveWindow - this.prevWindow >= this.clearAfterInactiveWindows;
    }

    public static TimedWindowCheckerBuilder builder() {
        return new TimedWindowCheckerBuilder();
    }

    public ThrottlingWindowUnit getUnit() {
        return this.unit;
    }

    public long getClearAfterInactiveWindows() {
        return this.clearAfterInactiveWindows;
    }

    public long getPrevWindow() {
        return this.prevWindow;
    }

    public long getLiveWindow() {
        return this.liveWindow;
    }

    public void setPrevWindow(long prevWindow) {
        this.prevWindow = prevWindow;
    }

    public void setLiveWindow(long liveWindow) {
        this.liveWindow = liveWindow;
    }

    public String toString() {
        return "TimedWindowChecker(super=" + super.toString() + ", unit=" + (Object)((Object)this.getUnit()) + ", clearAfterInactiveWindows=" + this.getClearAfterInactiveWindows() + ", prevWindow=" + this.getPrevWindow() + ", liveWindow=" + this.getLiveWindow() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimedWindowChecker)) {
            return false;
        }
        TimedWindowChecker other = (TimedWindowChecker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThrottlingWindowUnit this$unit = this.getUnit();
        ThrottlingWindowUnit other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit)) {
            return false;
        }
        if (this.getClearAfterInactiveWindows() != other.getClearAfterInactiveWindows()) {
            return false;
        }
        if (this.getPrevWindow() != other.getPrevWindow()) {
            return false;
        }
        return this.getLiveWindow() == other.getLiveWindow();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimedWindowChecker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ThrottlingWindowUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        long $clearAfterInactiveWindows = this.getClearAfterInactiveWindows();
        result = result * 59 + (int)($clearAfterInactiveWindows >>> 32 ^ $clearAfterInactiveWindows);
        long $prevWindow = this.getPrevWindow();
        result = result * 59 + (int)($prevWindow >>> 32 ^ $prevWindow);
        long $liveWindow = this.getLiveWindow();
        result = result * 59 + (int)($liveWindow >>> 32 ^ $liveWindow);
        return result;
    }

    public static class TimedWindowCheckerBuilder {
        private String commandName;
        private ThrottlingWindowUnit unit;
        private int threshold;
        private long clearAfterInactiveWindows;

        TimedWindowCheckerBuilder() {
        }

        public TimedWindowCheckerBuilder commandName(String commandName) {
            this.commandName = commandName;
            return this;
        }

        public TimedWindowCheckerBuilder unit(ThrottlingWindowUnit unit) {
            this.unit = unit;
            return this;
        }

        public TimedWindowCheckerBuilder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public TimedWindowCheckerBuilder clearAfterInactiveWindows(long clearAfterInactiveWindows) {
            this.clearAfterInactiveWindows = clearAfterInactiveWindows;
            return this;
        }

        public TimedWindowChecker build() {
            return new TimedWindowChecker(this.commandName, this.unit, this.threshold, this.clearAfterInactiveWindows);
        }

        public String toString() {
            return "TimedWindowChecker.TimedWindowCheckerBuilder(commandName=" + this.commandName + ", unit=" + (Object)((Object)this.unit) + ", threshold=" + this.threshold + ", clearAfterInactiveWindows=" + this.clearAfterInactiveWindows + ")";
        }
    }
}

