/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling.strategies.checker;

import io.kalp.athang.durg.kirtimukh.throttling.exception.ThrottlingException;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestsWindowChecker {
    private static final Logger log = LoggerFactory.getLogger(RequestsWindowChecker.class);
    private static final int MIN_BIT_SET_SIZE = 64;
    private final String commandName;
    private final BitSet bitSet;
    private final int threshold;
    private int currentLocation;

    protected RequestsWindowChecker(String commandName, int threshold) {
        this.commandName = commandName;
        this.threshold = threshold;
        int maxTicksPerWindow = RequestsWindowChecker.nPower(threshold);
        this.bitSet = new BitSet(maxTicksPerWindow);
    }

    private static int nPower(int number) {
        if (number < 0 || number == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int n = 1;
        while (number >= (n <<= 1)) {
        }
        return Math.max(n, 64);
    }

    protected abstract boolean isChangeInWindow();

    protected abstract boolean isOkayToClear();

    private boolean locate(int location) {
        if (this.isChangeInWindow()) {
            this.currentLocation = 0;
            if (this.isOkayToClear()) {
                log.debug("[{}] Clearing bitset", (Object)this.commandName);
                this.bitSet.clear();
            }
        }
        if (this.bitSet.get(location)) {
            return false;
        }
        this.bitSet.set(location);
        log.debug("[{}] Set at location: {} cardinality: {}", new Object[]{this.commandName, location, this.bitSet.cardinality()});
        return true;
    }

    public synchronized boolean release(int location) {
        this.bitSet.clear(location);
        return true;
    }

    public synchronized int acquire() {
        int marker;
        int cardinality = this.bitSet.cardinality();
        if (cardinality >= this.threshold) {
            log.warn("[{}] Cardinality {} exceeding allowed limit {}", new Object[]{this.commandName, cardinality, this.threshold});
            throw ThrottlingException.builder().cardinality(cardinality).threshold(this.threshold).message("Thank you contacting us! :-)").build();
        }
        log.debug("[{}] Cardinality {} allowed limit {}", new Object[]{this.commandName, cardinality, this.threshold});
        while (!this.locate(marker = this.bitSet.nextClearBit(this.currentLocation))) {
        }
        return marker;
    }
}

