/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling;

import com.google.inject.Singleton;
import io.kalp.athang.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.LeakyBucketTicker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.QuotaStrategyTicker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.StrategyChecker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.RequestsWindowChecker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.impl.TimedWindowChecker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class ThrottlingController {
    private final Map<String, RequestsWindowChecker> windowCheckerMap = new HashMap<String, RequestsWindowChecker>();
    private final Map<String, ThrottlingStrategyType> strategyTypeMap = new HashMap<String, ThrottlingStrategyType>();
    private final ThrottlingStrategyConfig defaultStrategyConfig;

    public ThrottlingController(ThrottlingStrategyConfig defaultConfig, List<ThrottlingStrategyConfig> configs) {
        this.defaultStrategyConfig = defaultConfig;
        for (ThrottlingStrategyConfig config : configs) {
            this.strategyTypeMap.put(config.getName(), config.getType());
            this.windowCheckerMap.put(config.getName(), this.getWindowChecker(config));
        }
    }

    private TimedWindowChecker getTimedWindowChecker(String commandName, ThrottlingStrategyConfig strategyConfig) {
        return TimedWindowChecker.builder().commandName(commandName).unit(strategyConfig.getUnit()).threshold(strategyConfig.getThreshold()).clearAfter(strategyConfig.getClearAfterWindows()).build();
    }

    private RequestsWindowChecker getWindowChecker(final String commandName, final ThrottlingStrategyConfig strategyConfig) {
        return strategyConfig.getUnit().accept(new ThrottlingWindowUnit.ThrottlingWindowVisitor<RequestsWindowChecker>(){

            @Override
            public RequestsWindowChecker visitMillisecond() {
                return ThrottlingController.this.getTimedWindowChecker(commandName, strategyConfig);
            }

            @Override
            public RequestsWindowChecker visitSecond() {
                return ThrottlingController.this.getTimedWindowChecker(commandName, strategyConfig);
            }

            @Override
            public RequestsWindowChecker visitMinute() {
                return ThrottlingController.this.getTimedWindowChecker(commandName, strategyConfig);
            }
        });
    }

    private RequestsWindowChecker getWindowChecker(ThrottlingStrategyConfig strategyConfig) {
        return this.getWindowChecker(strategyConfig.getName(), strategyConfig);
    }

    private synchronized RequestsWindowChecker getWindowChecker(String commandName) {
        if (!this.windowCheckerMap.containsKey(commandName)) {
            this.windowCheckerMap.put(commandName, this.getWindowChecker(commandName, this.defaultStrategyConfig));
        }
        return this.windowCheckerMap.get(commandName);
    }

    private StrategyChecker getStrategyChecker(String commandName) {
        final RequestsWindowChecker windowChecker = this.getWindowChecker(commandName);
        ThrottlingStrategyType strategyType = this.strategyTypeMap.getOrDefault(commandName, this.defaultStrategyConfig.getType());
        return strategyType.accept(new ThrottlingStrategyType.ThrottlingStrategyTypeVisitor<StrategyChecker>(){

            @Override
            public StrategyChecker visitQuota() {
                return new QuotaStrategyTicker(windowChecker);
            }

            @Override
            public StrategyChecker visitLeakyBucket() {
                return new LeakyBucketTicker(windowChecker);
            }

            @Override
            public StrategyChecker visitNg() {
                throw new UnsupportedOperationException("Ng strategy unsupported");
            }
        });
    }

    public Map<String, RequestsWindowChecker> getInfo() {
        return this.windowCheckerMap;
    }

    public StrategyChecker register(String rateLimitedFunctionName) {
        return this.getStrategyChecker(rateLimitedFunctionName);
    }
}

