/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling;

import io.kalp.athang.durg.kirtimukh.throttling.ThrottlingController;
import io.kalp.athang.durg.kirtimukh.throttling.annotation.Throttle;
import io.kalp.athang.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.kalp.athang.durg.kirtimukh.throttling.exception.ThrottlingExceptionTranslator;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.StrategyChecker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.RequestsWindowChecker;
import java.util.List;
import java.util.Map;

public final class ThrottlingManager {
    private static ThrottlingController controller;
    private static ThrottlingExceptionTranslator translator;

    public static void initialise(ThrottlingStrategyConfig defaultConfig, List<ThrottlingStrategyConfig> configs, ThrottlingExceptionTranslator exceptionTranslator) {
        controller = new ThrottlingController(defaultConfig, configs);
        translator = exceptionTranslator;
    }

    public static Map<String, RequestsWindowChecker> getInfo() {
        return controller.getInfo();
    }

    public static StrategyChecker register(Throttle throttle) {
        return controller.register(throttle.name());
    }

    public static StrategyChecker register(String rateLimitedFunctionName) {
        return controller.register(rateLimitedFunctionName);
    }

    private ThrottlingManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static ThrottlingExceptionTranslator getTranslator() {
        return translator;
    }
}

