/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.impl;

import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.RequestsWindowChecker;

public class RequestsPerSecondChecker
extends RequestsWindowChecker {
    private long prevWindow;
    private long liveWindow = this.getWindow();

    public RequestsPerSecondChecker(int threshold) {
        super(ThrottlingWindowUnit.SECOND, threshold);
    }

    private long getWindow() {
        long mills = System.currentTimeMillis();
        return (mills - mills % 1000L) / 1000L;
    }

    @Override
    public boolean isChangeInWindow() {
        long window = this.getWindow();
        if (this.liveWindow != window) {
            this.prevWindow = this.liveWindow;
            this.liveWindow = window;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isOkayToClear() {
        return this.liveWindow - this.prevWindow >= 5L;
    }

    public static RequestsPerSecondCheckerBuilder builder() {
        return new RequestsPerSecondCheckerBuilder();
    }

    public long getPrevWindow() {
        return this.prevWindow;
    }

    public long getLiveWindow() {
        return this.liveWindow;
    }

    public void setPrevWindow(long prevWindow) {
        this.prevWindow = prevWindow;
    }

    public void setLiveWindow(long liveWindow) {
        this.liveWindow = liveWindow;
    }

    public String toString() {
        return "RequestsPerSecondChecker(super=" + super.toString() + ", prevWindow=" + this.getPrevWindow() + ", liveWindow=" + this.getLiveWindow() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestsPerSecondChecker)) {
            return false;
        }
        RequestsPerSecondChecker other = (RequestsPerSecondChecker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPrevWindow() != other.getPrevWindow()) {
            return false;
        }
        return this.getLiveWindow() == other.getLiveWindow();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestsPerSecondChecker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $prevWindow = this.getPrevWindow();
        result = result * 59 + (int)($prevWindow >>> 32 ^ $prevWindow);
        long $liveWindow = this.getLiveWindow();
        result = result * 59 + (int)($liveWindow >>> 32 ^ $liveWindow);
        return result;
    }

    public static class RequestsPerSecondCheckerBuilder {
        private int threshold;

        RequestsPerSecondCheckerBuilder() {
        }

        public RequestsPerSecondCheckerBuilder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public RequestsPerSecondChecker build() {
            return new RequestsPerSecondChecker(this.threshold);
        }

        public String toString() {
            return "RequestsPerSecondChecker.RequestsPerSecondCheckerBuilder(threshold=" + this.threshold + ")";
        }
    }
}

