/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.impl;

import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.RequestsWindowChecker;

public class RequestsPerMillisChecker
extends RequestsWindowChecker {
    private long prevWindow;
    private long liveWindow = this.getWindow();

    public RequestsPerMillisChecker(int threshold) {
        super(ThrottlingWindowUnit.MILLISECOND, threshold);
    }

    private long getWindow() {
        return System.currentTimeMillis();
    }

    @Override
    public boolean isChangeInWindow() {
        long window = this.getWindow();
        if (this.liveWindow != window) {
            this.prevWindow = this.liveWindow;
            this.liveWindow = window;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isOkayToClear() {
        return this.liveWindow - this.prevWindow >= 5L;
    }

    public static RequestsPerMillisCheckerBuilder builder() {
        return new RequestsPerMillisCheckerBuilder();
    }

    public long getPrevWindow() {
        return this.prevWindow;
    }

    public long getLiveWindow() {
        return this.liveWindow;
    }

    public void setPrevWindow(long prevWindow) {
        this.prevWindow = prevWindow;
    }

    public void setLiveWindow(long liveWindow) {
        this.liveWindow = liveWindow;
    }

    public String toString() {
        return "RequestsPerMillisChecker(super=" + super.toString() + ", prevWindow=" + this.getPrevWindow() + ", liveWindow=" + this.getLiveWindow() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestsPerMillisChecker)) {
            return false;
        }
        RequestsPerMillisChecker other = (RequestsPerMillisChecker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPrevWindow() != other.getPrevWindow()) {
            return false;
        }
        return this.getLiveWindow() == other.getLiveWindow();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestsPerMillisChecker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $prevWindow = this.getPrevWindow();
        result = result * 59 + (int)($prevWindow >>> 32 ^ $prevWindow);
        long $liveWindow = this.getLiveWindow();
        result = result * 59 + (int)($liveWindow >>> 32 ^ $liveWindow);
        return result;
    }

    public static class RequestsPerMillisCheckerBuilder {
        private int threshold;

        RequestsPerMillisCheckerBuilder() {
        }

        public RequestsPerMillisCheckerBuilder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public RequestsPerMillisChecker build() {
            return new RequestsPerMillisChecker(this.threshold);
        }

        public String toString() {
            return "RequestsPerMillisChecker.RequestsPerMillisCheckerBuilder(threshold=" + this.threshold + ")";
        }
    }
}

