/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling.strategies.checker;

import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.kalp.athang.durg.kirtimukh.throttling.exception.ThrottlingException;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestsWindowChecker {
    private static final Logger log = LoggerFactory.getLogger(RequestsWindowChecker.class);
    private static final int MIN_BIT_SET_SIZE = 64;
    private final BitSet bitSet;
    private final ThrottlingWindowUnit unit;
    private final int threshold;
    private int currentLocation;

    protected RequestsWindowChecker(ThrottlingWindowUnit unit, int threshold) {
        this.unit = unit;
        this.threshold = threshold;
        int maxTicksPerWindow = RequestsWindowChecker.nPower(threshold);
        this.bitSet = new BitSet(maxTicksPerWindow);
    }

    private static int nPower(int number) {
        if (number < 0 || number == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int n = 1;
        while (number >= (n <<= 1)) {
        }
        return Math.max(n, 64);
    }

    protected abstract boolean isChangeInWindow();

    protected abstract boolean isOkayToClear();

    private boolean locate(int location) {
        if (this.isChangeInWindow()) {
            this.currentLocation = 0;
            if (this.isOkayToClear()) {
                log.debug("Clearing bitset");
                this.bitSet.clear();
            }
        }
        if (this.bitSet.get(location)) {
            return false;
        }
        this.bitSet.set(location);
        log.debug("Set at location: " + location + " cardinality: " + this.bitSet.cardinality());
        return true;
    }

    public synchronized boolean release(int location) {
        this.bitSet.clear(location);
        return true;
    }

    public synchronized int acquire() {
        int marker;
        int cardinality = this.bitSet.cardinality();
        if (cardinality >= this.threshold) {
            log.warn("Cardinality " + cardinality + " is about to exceed allowed limit " + this.threshold);
            System.out.println("Cardinality " + cardinality + " is about to exceed allowed limit " + this.threshold);
            throw ThrottlingException.builder().unit(this.unit).cardinality(cardinality).threshold(this.threshold).message("Thank you contacting us! :-)").build();
        }
        log.info("Cardinality " + cardinality + " allowed limit " + this.threshold);
        System.out.println("Cardinality " + cardinality + " allowed limit " + this.threshold);
        while (!this.locate(marker = this.bitSet.nextClearBit(this.currentLocation))) {
        }
        return marker;
    }
}

