/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.aop;

import com.google.common.base.Strings;
import io.kalp.athang.durg.kirtimukh.throttling.ThrottlingManager;
import io.kalp.athang.durg.kirtimukh.throttling.annotation.Throttle;
import io.kalp.athang.durg.kirtimukh.throttling.exception.ThrottlingException;
import io.kalp.athang.durg.kirtimukh.throttling.exception.ThrottlingExceptionTranslator;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.StrategyChecker;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ThrottlingFunctionWrapper {
    private static final Logger log = LoggerFactory.getLogger(ThrottlingFunctionWrapper.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ ThrottlingFunctionWrapper ajc$perSingletonInstance;

    @Pointcut(value="@annotation(io.kalp.athang.durg.kirtimukh.throttling.annotation.Throttle)")
    public void pointCutFunction() {
    }

    @Pointcut(value="execution(* *(..))")
    public void pointCutExecution() {
    }

    public StrategyChecker getStrategyChecker(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)MethodSignature.class.cast(joinPoint.getSignature());
        Throttle rateLimited = methodSignature.getMethod().getAnnotation(Throttle.class);
        if (rateLimited == null) {
            throw new UnsupportedOperationException("Not an interceptedFunction");
        }
        StrategyChecker checker = null;
        checker = Strings.isNullOrEmpty((String)rateLimited.name()) ? ThrottlingManager.register(methodSignature.getDeclaringType().getSimpleName() + '.' + methodSignature.getMethod().getName()) : ThrottlingManager.register(rateLimited);
        return checker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointCutFunction() && pointCutExecution()")
    public Object process(ProceedingJoinPoint joinPoint) throws Throwable {
        StrategyChecker checker = this.getStrategyChecker((JoinPoint)joinPoint);
        ThrottlingExceptionTranslator translator = ThrottlingManager.getTranslator();
        if (translator != null) {
            try {
                checker.enter();
            }
            catch (ThrottlingException e) {
                throw translator.throwable(e);
            }
        } else {
            checker.enter();
        }
        Object response = null;
        try {
            response = joinPoint.proceed();
        }
        finally {
            checker.exit();
        }
        return response;
    }

    static {
        try {
            ThrottlingFunctionWrapper.ajc$perSingletonInstance = new ThrottlingFunctionWrapper();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static ThrottlingFunctionWrapper aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("io.kalp.athang.aop.ThrottlingFunctionWrapper", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

